/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.TransactionStatusManager;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.objectstore.LogStore;

public class TxControl {
    public static final int NODE_NAME_SIZE = 64;
    public static final String DEFAULT_NODE_NAME = "Arjuna:";
    static boolean maintainHeuristics;
    static boolean asyncCommit;
    static boolean asyncPrepare;
    static boolean asyncRollback;
    static boolean onePhase;
    static boolean readonlyOptimisation;
    static boolean sharedTransactionLog;
    static int numberOfTransactions;
    static volatile boolean enable;
    private static TransactionStatusManager transactionStatusManager;
    static String actionStoreType;
    private static ObjectStore _objectStore;
    private static ObjectStore _recoveryStore;
    static byte[] xaNodeName;
    static int _defaultTimeout;
    static boolean _enableTSM;
    static boolean beforeCompletionWhenRollbackOnly;
    static Thread _shutdownHook;
    static Object _lock;

    public static final int getDefaultTimeout() {
        return _defaultTimeout;
    }

    public static final void setDefaultTimeout(int timeout) {
        _defaultTimeout = timeout;
    }

    public static final synchronized void enable() {
        TxControl.createTransactionStatusManager();
        enable = true;
    }

    public static final synchronized void disable() {
        TxControl.disable(false);
    }

    public static final synchronized void disable(boolean disableRecovery) {
        if (disableRecovery) {
            TxControl.removeTransactionStatusManager();
        }
        enable = false;
    }

    public static final boolean isEnabled() {
        return enable;
    }

    public static final String getActionStoreType() {
        return actionStoreType;
    }

    public static final ObjectStore getRecoveryStore() {
        if (_recoveryStore != null) {
            return _recoveryStore;
        }
        if (actionStoreType == null) {
            actionStoreType = arjPropertyManager.getCoordinatorEnvironmentBean().isTransactionLog() ? LogStore.class.getName() : arjPropertyManager.getCoordinatorEnvironmentBean().getActionStore();
            sharedTransactionLog = arjPropertyManager.getCoordinatorEnvironmentBean().isSharedTransactionLog();
        }
        String recoveryType = actionStoreType;
        if (actionStoreType.equals(LogStore.class.getName())) {
            recoveryType = arjPropertyManager.getCoordinatorEnvironmentBean().getActionStore();
        }
        if (sharedTransactionLog) {
            arjPropertyManager.getObjectStoreEnvironmentBean().setShare(13);
        }
        try {
            Class<?> osc = Class.forName(recoveryType);
            _recoveryStore = (ObjectStore)osc.newInstance();
        }
        catch (Throwable ex) {
            throw new FatalError(tsLogger.arjLoggerI18N.getString("com.arjuna.ats.arjuna.coordinator.invalidos") + " " + recoveryType);
        }
        return _recoveryStore;
    }

    public static final ObjectStore getStore() {
        if (_objectStore != null) {
            return _objectStore;
        }
        if (actionStoreType == null) {
            actionStoreType = arjPropertyManager.getCoordinatorEnvironmentBean().isTransactionLog() ? LogStore.class.getName() : arjPropertyManager.getCoordinatorEnvironmentBean().getActionStore();
            sharedTransactionLog = arjPropertyManager.getCoordinatorEnvironmentBean().isSharedTransactionLog();
        }
        if (sharedTransactionLog) {
            arjPropertyManager.getObjectStoreEnvironmentBean().setShare(13);
        }
        try {
            Class<?> osc = Class.forName(actionStoreType);
            _objectStore = (ObjectStore)osc.newInstance();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new FatalError(tsLogger.arjLoggerI18N.getString("com.arjuna.ats.arjuna.coordinator.invalidos") + " " + actionStoreType);
        }
        return _objectStore;
    }

    public static final boolean getAsyncPrepare() {
        return asyncPrepare;
    }

    public static final boolean getMaintainHeuristics() {
        return maintainHeuristics;
    }

    public static boolean isReadonlyOptimisation() {
        return readonlyOptimisation;
    }

    public static final byte[] getXANodeName() {
        return xaNodeName;
    }

    public static void setXANodeName(byte[] name) {
        if (name.length > 64) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.toolong");
            }
            throw new IllegalArgumentException();
        }
        xaNodeName = name;
    }

    public static boolean isBeforeCompletionWhenRollbackOnly() {
        return beforeCompletionWhenRollbackOnly;
    }

    private static final synchronized void createTransactionStatusManager() {
        if (transactionStatusManager == null && _enableTSM) {
            transactionStatusManager = new TransactionStatusManager();
            _shutdownHook = new Shutdown();
            Runtime.getRuntime().addShutdownHook(_shutdownHook);
        }
    }

    private static final synchronized void removeTransactionStatusManager() {
        if (_shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(_shutdownHook);
            _shutdownHook = null;
            if (transactionStatusManager != null) {
                transactionStatusManager.shutdown();
                transactionStatusManager = null;
            }
        }
    }

    static {
        String nodeName;
        maintainHeuristics = true;
        asyncCommit = false;
        asyncPrepare = false;
        asyncRollback = false;
        onePhase = true;
        readonlyOptimisation = true;
        sharedTransactionLog = false;
        numberOfTransactions = 100;
        enable = true;
        transactionStatusManager = null;
        actionStoreType = null;
        _objectStore = null;
        _recoveryStore = null;
        xaNodeName = null;
        _defaultTimeout = 60;
        _enableTSM = true;
        beforeCompletionWhenRollbackOnly = false;
        _shutdownHook = null;
        _lock = new Object();
        _defaultTimeout = arjPropertyManager.getCoordinatorEnvironmentBean().getDefaultTimeout();
        maintainHeuristics = arjPropertyManager.getCoordinatorEnvironmentBean().isMaintainHeuristics();
        asyncCommit = arjPropertyManager.getCoordinatorEnvironmentBean().isAsyncCommit();
        asyncPrepare = arjPropertyManager.getCoordinatorEnvironmentBean().isAsyncPrepare();
        onePhase = arjPropertyManager.getCoordinatorEnvironmentBean().isCommitOnePhase();
        asyncRollback = arjPropertyManager.getCoordinatorEnvironmentBean().isAsyncRollback();
        readonlyOptimisation = arjPropertyManager.getCoordinatorEnvironmentBean().isReadonlyOptimisation();
        enable = !arjPropertyManager.getCoordinatorEnvironmentBean().isStartDisabled();
        beforeCompletionWhenRollbackOnly = arjPropertyManager.getCoordinatorEnvironmentBean().isBeforeCompletionWhenRollbackOnly();
        String env = arjPropertyManager.getCoreEnvironmentBean().getNodeIdentifier();
        boolean writeNodeName = false;
        if (env != null) {
            xaNodeName = env.getBytes();
        } else {
            nodeName = DEFAULT_NODE_NAME + Utility.getpid();
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TxControl_1", new Object[]{nodeName});
            }
            xaNodeName = nodeName.getBytes();
            writeNodeName = true;
        }
        if (xaNodeName.length > 64) {
            nodeName = DEFAULT_NODE_NAME + Utility.getpid();
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TxControl_2", new Object[]{nodeName});
            }
            xaNodeName = nodeName.getBytes();
            writeNodeName = true;
        }
        if (env != null && env.indexOf(45) != -1) {
            nodeName = DEFAULT_NODE_NAME + Utility.getpid();
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TxControl_3", new Object[]{nodeName});
            }
            xaNodeName = nodeName.getBytes();
            writeNodeName = true;
        }
        if (writeNodeName) {
            arjPropertyManager.getCoreEnvironmentBean().setNodeIdentifier(new String(xaNodeName));
        }
        _enableTSM = arjPropertyManager.getCoordinatorEnvironmentBean().isTransactionStatusManagerEnable();
        TxControl.createTransactionStatusManager();
    }

    public static class Shutdown
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<TxControl> clazz = TxControl.class;
            synchronized (TxControl.class) {
                if (_shutdownHook == this && transactionStatusManager != null) {
                    transactionStatusManager.shutdown();
                    transactionStatusManager = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

