/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.objectstore.type.ObjectStoreTypeManager;
import com.arjuna.ats.internal.arjuna.objectstore.ActionStore;
import com.arjuna.ats.internal.arjuna.objectstore.CacheStore;
import com.arjuna.ats.internal.arjuna.objectstore.HashedActionStore;
import com.arjuna.ats.internal.arjuna.objectstore.HashedStore;
import com.arjuna.ats.internal.arjuna.objectstore.JDBCActionStore;
import com.arjuna.ats.internal.arjuna.objectstore.JDBCStore;
import com.arjuna.ats.internal.arjuna.objectstore.LogStore;
import com.arjuna.ats.internal.arjuna.objectstore.NullActionStore;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowNoFileLockStore;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore;
import com.arjuna.ats.internal.arjuna.objectstore.VolatileStore;
import java.io.PrintWriter;

public class ObjectStoreType {
    public static final int ACTION = 0;
    public static final int ACTIONLOG = 1;
    public static final int SHADOWING = 2;
    public static final int FRAGMENTED = 3;
    public static final int VOLATILE = 4;
    public static final int HASHED = 5;
    public static final int REPLICATED = 6;
    public static final int MAPPED = 7;
    public static final int SINGLETYPEMAPPED = 8;
    public static final int USER_DEF_0 = 9;
    public static final int USER_DEF_1 = 10;
    public static final int USER_DEF_2 = 11;
    public static final int USER_DEF_3 = 12;
    public static final int USER_DEF_4 = 13;
    public static final int SHADOWNOFILELOCK = 14;
    public static final int JDBC = 15;
    public static final int JDBC_ACTION = 16;
    public static final int HASHED_ACTION = 17;
    public static final int CACHED = 18;
    public static final int NULL_ACTION = 19;
    public static final int USER_DEF_5 = 30;
    public static final int USER_DEF_6 = 31;
    public static final int USER_DEF_7 = 32;
    public static final int USER_DEF_8 = 33;
    public static final int USER_DEF_9 = 34;
    static String objectStoreType = null;

    public static final Class<? extends ObjectStore> typeToClass(int rt) {
        switch (rt) {
            case 0: {
                return ActionStore.class;
            }
            case 19: {
                return NullActionStore.class;
            }
            case 1: {
                return LogStore.class;
            }
            case 2: {
                return ShadowingStore.class;
            }
            case 4: {
                return VolatileStore.class;
            }
            case 5: {
                return HashedStore.class;
            }
            case 14: {
                return ShadowNoFileLockStore.class;
            }
            case 15: {
                return JDBCStore.class;
            }
            case 16: {
                return JDBCActionStore.class;
            }
            case 17: {
                return HashedActionStore.class;
            }
            case 18: {
                return CacheStore.class;
            }
        }
        return ObjectStoreTypeManager.manager().getObjectStoreClass(rt);
    }

    public static final int classToType(Class c) {
        if (c.equals(ActionStore.class)) {
            return 0;
        }
        if (c.equals(NullActionStore.class)) {
            return 19;
        }
        if (c.equals(LogStore.class)) {
            return 1;
        }
        if (c.equals(ShadowingStore.class)) {
            return 2;
        }
        if (c.equals(VolatileStore.class)) {
            return 4;
        }
        if (c.equals(HashedStore.class)) {
            return 5;
        }
        if (c.equals(ShadowNoFileLockStore.class)) {
            return 14;
        }
        if (c.equals(JDBCStore.class)) {
            return 15;
        }
        if (c.equals(JDBCActionStore.class)) {
            return 16;
        }
        if (c.equals(HashedActionStore.class)) {
            return 17;
        }
        if (c.equals(CacheStore.class)) {
            return 18;
        }
        int type = ObjectStoreTypeManager.manager().getType(c);
        if (type >= 0) {
            return type;
        }
        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.objectstore.ObjectStoreType_1", new Object[]{c});
        }
        throw new FatalError(tsLogger.arjLoggerI18N.getString("com.arjuna.ats.arjuna.objectstore.ObjectStoreType_2") + c);
    }

    public static final void print(PrintWriter strm, int rt) {
        Class<? extends ObjectStore> c = ObjectStoreType.typeToClass(rt);
        strm.print(c);
        c = null;
    }

    public static final boolean valid(int rt) {
        return ObjectStoreType.typeToClass(rt) != null;
    }

    public static final String getDefaultStoreType() {
        if (objectStoreType == null) {
            objectStoreType = arjPropertyManager.getObjectStoreEnvironmentBean().getObjectStoreType();
        }
        return objectStoreType;
    }
}

