/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.tools.log;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.coordinator.RecordListIterator;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseOutcome;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.tools.log.EditableTransaction;

public class EditableAtomicAction
extends AtomicAction
implements EditableTransaction {
    private boolean _activated = this.activate();

    public EditableAtomicAction(Uid u) {
        super(u);
        if (!this._activated && tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.tools.log.eaa1", new Object[]{u, this.type()});
        }
    }

    @Override
    public void moveHeuristicToPrepared(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.heuristicList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.heuristicList.size() == 0) {
            throw new IndexOutOfBoundsException();
        }
        RecordListIterator iter = new RecordListIterator(this.heuristicList);
        AbstractRecord rec = iter.iterate();
        for (int i = 0; i < index; ++i) {
            rec = iter.iterate();
        }
        if (rec.forgetHeuristic()) {
            this.heuristicList.remove(rec);
            this.preparedList.insert(rec);
            if (this.heuristicList.size() == 0) {
                super.setHeuristicDecision(7);
            }
            super.updateState();
        } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.tools.log.eaa2");
        }
    }

    @Override
    public void deleteHeuristicParticipant(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.heuristicList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.heuristicList.size() == 0) {
            throw new IndexOutOfBoundsException();
        }
        RecordListIterator iter = new RecordListIterator(this.heuristicList);
        AbstractRecord rec = iter.iterate();
        for (int i = 0; i < index; ++i) {
            rec = iter.iterate();
        }
        this.heuristicList.remove(rec);
        if (this.heuristicList.size() == 0) {
            super.setHeuristicDecision(7);
        }
        super.updateState();
    }

    @Override
    public String toString() {
        int i;
        AbstractRecord rec;
        RecordListIterator iter;
        if (!this._activated) {
            return "RecoveryAction not activated.";
        }
        String printableForm = "ActionStatus: " + ActionStatus.stringForm(super.status());
        printableForm = printableForm + "\nHeuristic Decision: " + TwoPhaseOutcome.stringForm(super.getHeuristicDecision());
        if (this.preparedList.size() == 0) {
            printableForm = printableForm + "\nNo prepared entries.";
        } else {
            printableForm = printableForm + "\nPrepared entries:";
            iter = new RecordListIterator(this.preparedList);
            rec = iter.iterate();
            i = 0;
            while (rec != null) {
                printableForm = printableForm + "\n[" + i + "] " + rec;
                rec = iter.iterate();
                ++i;
            }
        }
        if (this.heuristicList.size() == 0) {
            printableForm = printableForm + "\nNo heuristic entries.";
        } else {
            printableForm = printableForm + "\nHeuristic entries:";
            iter = new RecordListIterator(this.heuristicList);
            rec = iter.iterate();
            i = 0;
            while (rec != null) {
                printableForm = printableForm + "\n[" + i + "] " + rec;
                rec = iter.iterate();
                ++i;
            }
        }
        return printableForm;
    }
}

