/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.recoverycoordinators;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.internal.jts.orbspecific.recovery.RecoveryEnablement;
import com.arjuna.ats.internal.jts.recovery.RecoveryCreator;
import com.arjuna.ats.internal.jts.recovery.recoverycoordinators.RcvCoManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;

public class GenericRecoveryCreator
extends RecoveryCreator {
    private RcvCoManager _orbSpecificManager;
    private static final char _RecCoordServiceObjKeyDelimiter = '*';
    private static final String _RecCoordServiceBaseName = "RecCoService_";

    private GenericRecoveryCreator(RcvCoManager specificManager) {
        this._orbSpecificManager = specificManager;
    }

    public static void register(RcvCoManager theManager) {
        GenericRecoveryCreator theCreator = new GenericRecoveryCreator(theManager);
        RecoveryCreator.setCreator(theCreator);
    }

    @Override
    public RecoveryCoordinator create(Resource res, Object[] params) throws SystemException {
        RecoveryCoordinator recoveryCoordinator = null;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug("GenericRecoveryCreator.create()");
        }
        if (params != null && params[0] != null) {
            ArjunaTransactionImple otsTransaction;
            int index = 0;
            BasicAction rootAction = otsTransaction = (ArjunaTransactionImple)params[index++];
            while (rootAction.parent() != null) {
                rootAction = rootAction.parent();
            }
            Uid rootActionUid = rootAction.getSavingUid();
            Uid processUid = Utility.getProcessUid();
            Uid RCUid = new Uid();
            boolean isServerTransaction = otsTransaction instanceof ServerTransaction;
            recoveryCoordinator = this._orbSpecificManager.makeRC(RCUid, rootActionUid, processUid, isServerTransaction);
            otsTransaction = null;
            rootAction = null;
            params[0] = RCUid;
        } else {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.recoverycoordinators.GenericRecoveryCreator_1");
        }
        return recoveryCoordinator;
    }

    @Override
    public void destroy(RecoveryCoordinator rc) throws SystemException {
        this._orbSpecificManager.destroy(rc);
    }

    @Override
    public void destroyAll(Object[] params) throws SystemException {
        this._orbSpecificManager.destroyAll(params);
    }

    public static String getRecCoordServiceName() {
        String tag = RecoveryEnablement.getRecoveryManagerTag();
        if (tag != null) {
            return new String(_RecCoordServiceBaseName + tag);
        }
        return null;
    }
}

