/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.logging;

import com.arjuna.common.internal.util.logging.LogFactoryInterface;
import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.internal.util.logging.LogNoi18nImpl;
import com.arjuna.common.internal.util.logging.Logi18nDelegatingImpl;
import com.arjuna.common.internal.util.logging.Logi18nImpl;
import com.arjuna.common.internal.util.logging.Logi18nInterface;
import com.arjuna.common.internal.util.logging.commonPropertyManager;
import com.arjuna.common.util.exceptions.LogConfigurationException;
import com.arjuna.common.util.logging.LogNoi18n;
import com.arjuna.common.util.logging.Logi18n;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class LogFactory {
    private static LogFactoryInterface m_logFactory = null;
    private static boolean m_isInitialized = false;

    public static void initializeModuleLogger(Class moduleLogger, String bundleName, String name) {
        Logi18n loggerI18N;
        LogNoi18n logger = LogFactory.getLogNoi18n(name);
        String _language = commonPropertyManager.getLoggingEnvironmentBean().getLanguage();
        String _country = commonPropertyManager.getLoggingEnvironmentBean().getCountry();
        try {
            loggerI18N = LogFactory.getLogi18n(name, bundleName + "_" + _language + "_" + _country);
        }
        catch (Throwable ex) {
            loggerI18N = LogFactory.getLogi18n(name, bundleName + "_en_US");
        }
        try {
            Method initializer = moduleLogger.getMethod("initialize", LogNoi18n.class, Logi18n.class);
            initializer.invoke(null, logger, loggerI18N);
        }
        catch (Exception e) {
            throw new RuntimeException("An unexpected exception occurred while initializing the logger: " + e.getMessage(), e);
        }
    }

    public static LogNoi18n getLogNoi18n(String name) {
        LogFactory.setupLogSystem();
        LogInterface logInterface = m_logFactory.getLog(name);
        LogNoi18nImpl log = new LogNoi18nImpl(logInterface);
        return log;
    }

    public static Logi18n getLogi18n(String name, String resBundle) {
        Logi18nImpl log;
        LogFactory.setupLogSystem();
        if (m_logFactory.isInternationalizationSupported()) {
            Logi18nInterface logi18nInterface = m_logFactory.getLog(name, resBundle);
            log = new Logi18nDelegatingImpl(logi18nInterface, resBundle);
        } else {
            LogInterface logInterface = m_logFactory.getLog(name);
            log = new Logi18nImpl(logInterface, resBundle);
        }
        return log;
    }

    public static synchronized void reset() {
        m_isInitialized = false;
    }

    private static synchronized void setupLogSystem() {
        if (m_isInitialized) {
            return;
        }
        try {
            String logFactory = commonPropertyManager.getLoggingEnvironmentBean().getLoggingFactory();
            int semicolonIndex = logFactory.indexOf(";");
            m_logFactory = semicolonIndex == -1 ? LogFactory.loadFactory(logFactory, null) : LogFactory.loadFactory(logFactory.substring(0, semicolonIndex), logFactory.substring(semicolonIndex + 1));
        }
        catch (LogConfigurationException e) {
            throw new RuntimeException("An unexpected exception occurred while creating the logger factory: " + e.getMessage(), e);
        }
        m_isInitialized = true;
    }

    private static LogFactoryInterface loadFactory(String classname, String arg) throws LogConfigurationException {
        try {
            LogFactoryInterface logFactoryInterface;
            Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass(classname);
            if (arg == null) {
                logFactoryInterface = (LogFactoryInterface)factoryClass.newInstance();
            } else {
                Constructor<?> ctor = factoryClass.getConstructor(String.class);
                logFactoryInterface = (LogFactoryInterface)ctor.newInstance(arg);
            }
            return logFactoryInterface;
        }
        catch (Exception e) {
            throw new LogConfigurationException(e);
        }
    }
}

