/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.osgi.parser.Attribute;
import org.jboss.as.osgi.parser.Element;
import org.jboss.as.osgi.parser.OSGiSubsystemAdd;
import org.jboss.as.osgi.parser.OSGiSubsystemState;
import org.jboss.as.osgi.parser.OSGiSubsystemUpdate;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class OSGiSubsystemElement
extends AbstractSubsystemElement<OSGiSubsystemElement> {
    private static final long serialVersionUID = 1543336372548202423L;
    private OSGiSubsystemState subsystemState = new OSGiSubsystemState();

    OSGiSubsystemElement() {
        super("urn:jboss:domain:osgi:1.0");
    }

    OSGiSubsystemState getSubsystemState() {
        return this.subsystemState;
    }

    void setSubsystemState(OSGiSubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    protected Class<OSGiSubsystemElement> getElementClass() {
        return OSGiSubsystemElement.class;
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<OSGiSubsystemElement, ?>> list) {
        list.add(new OSGiSubsystemUpdate(this.subsystemState));
    }

    protected boolean isEmpty() {
        return this.subsystemState.isEmpty();
    }

    protected AbstractSubsystemAdd<OSGiSubsystemElement> getAdd() {
        return new OSGiSubsystemAdd();
    }

    protected <P> void applyRemove(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        OSGiSubsystemElement oSGiSubsystemElement = this;
        synchronized (oSGiSubsystemElement) {
            List<OSGiSubsystemState.OSGiModule> modules;
            OSGiSubsystemState.Activation policy = this.subsystemState.getActivationPolicy();
            streamWriter.writeAttribute(Attribute.ACTIVATION.getLocalName(), policy.name().toLowerCase());
            Map<String, Object> properties = this.subsystemState.getProperties();
            if (!properties.isEmpty()) {
                streamWriter.writeStartElement(Element.PROPERTIES.getLocalName());
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    streamWriter.writeStartElement(Element.PROPERTY.getLocalName());
                    streamWriter.writeAttribute(Attribute.NAME.getLocalName(), entry.getKey());
                    streamWriter.writeCharacters((String)entry.getValue());
                    streamWriter.writeEndElement();
                }
                streamWriter.writeEndElement();
            }
            if (!(modules = this.subsystemState.getModules()).isEmpty()) {
                streamWriter.writeStartElement(Element.MODULES.getLocalName());
                for (OSGiSubsystemState.OSGiModule module : modules) {
                    ModuleIdentifier identifier = module.getIdentifier();
                    streamWriter.writeStartElement(Element.MODULE.getLocalName());
                    String canonicalName = identifier.getName() + ":" + identifier.getSlot();
                    streamWriter.writeAttribute(Attribute.IDENTIFIER.getLocalName(), canonicalName);
                    if (module.isStart()) {
                        streamWriter.writeAttribute(Attribute.START.getLocalName(), "true");
                    }
                    streamWriter.writeEndElement();
                }
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
        }
    }
}

