/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.ExtensionContext;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.as.osgi.parser.Attribute;
import org.jboss.as.osgi.parser.Element;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.OSGiSubsystemAdd;
import org.jboss.as.osgi.parser.OSGiSubsystemElement;
import org.jboss.as.osgi.parser.OSGiSubsystemState;
import org.jboss.as.osgi.parser.OSGiSubsystemUpdate;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class OSGiSubsystemElementParser
implements XMLStreamConstants,
XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<OSGiSubsystemElement>>> {
    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<OSGiSubsystemElement>> result) throws XMLStreamException {
        OSGiSubsystemAdd add = new OSGiSubsystemAdd();
        OSGiSubsystemState subsystemState = add.getSubsystemState();
        this.parseActivationAttribute(reader, subsystemState);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PROPERTIES: {
                            this.parsePropertiesElement(reader, subsystemState);
                            continue block7;
                        }
                        case MODULES: {
                            this.parseModulesElement(reader, subsystemState);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ArrayList<OSGiSubsystemUpdate> updates = new ArrayList<OSGiSubsystemUpdate>();
        updates.add(new OSGiSubsystemUpdate(subsystemState));
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)add, updates));
    }

    private void parseActivationAttribute(XMLExtendedStreamReader reader, OSGiSubsystemState subsystemState) throws XMLStreamException {
        switch (Namespace.forUri(reader.getNamespaceURI())) {
            case OSGI_1_0: {
                OSGiSubsystemState.Activation value = null;
                int count = reader.getAttributeCount();
                block6: for (int i = 0; i < count; ++i) {
                    String attrValue = reader.getAttributeValue(i);
                    if (reader.getAttributeNamespace(i) != null) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case ACTIVATION: {
                            value = OSGiSubsystemState.Activation.valueOf(attrValue.toUpperCase());
                            subsystemState.setActivation(value);
                            continue block6;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    void parsePropertiesElement(XMLExtendedStreamReader reader, OSGiSubsystemState subsystemState) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == Element.PROPERTY) {
                        String name = null;
                        String value = null;
                        int count = reader.getAttributeCount();
                        block7: for (int i = 0; i < count; ++i) {
                            String attrValue = reader.getAttributeValue(i);
                            if (reader.getAttributeNamespace(i) != null) {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = attrValue;
                                    if (!subsystemState.getProperties().containsKey(name)) continue block7;
                                    throw new XMLStreamException("Property " + name + " already exists", reader.getLocation());
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                        }
                        value = reader.getElementText().trim();
                        if (value == null || value.length() == 0) {
                            throw new XMLStreamException("Value for property " + name + " is null", reader.getLocation());
                        }
                        subsystemState.addProperty(name, value);
                        continue block6;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (subsystemState.getProperties().size() == 0) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.PROPERTY));
        }
    }

    void parseModulesElement(XMLExtendedStreamReader reader, OSGiSubsystemState subsystemState) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<ModuleIdentifier> identifiers = new HashSet<ModuleIdentifier>();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == Element.MODULE) {
                        ModuleIdentifier identifier = null;
                        boolean start = false;
                        int count = reader.getAttributeCount();
                        block8: for (int i = 0; i < count; ++i) {
                            if (reader.getAttributeNamespace(i) != null) {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case IDENTIFIER: {
                                    identifier = ModuleIdentifier.fromString((String)reader.getAttributeValue(i));
                                    continue block8;
                                }
                                case START: {
                                    start = Boolean.parseBoolean(reader.getAttributeValue(i));
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (identifier == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.IDENTIFIER));
                        }
                        if (identifiers.contains(identifier)) {
                            throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                        }
                        subsystemState.addModule(new OSGiSubsystemState.OSGiModule(identifier, start));
                        identifiers.add(identifier);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block7;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (subsystemState.getModules().size() == 0) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.MODULE));
        }
    }
}

