/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import org.jboss.as.osgi.service.FrameworkService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class PackageAdminService
implements Service<PackageAdmin> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"osgi", "packageadmin"});
    private InjectedValue<BundleContext> injectedContext = new InjectedValue();
    private PackageAdmin packageAdmin;

    public static void addService(BatchBuilder batchBuilder) {
        PackageAdminService service = new PackageAdminService();
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(SERVICE_NAME, (Service)service);
        serviceBuilder.addDependency(FrameworkService.SERVICE_NAME, BundleContext.class, service.injectedContext);
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public static PackageAdmin getServiceValue(ServiceContainer container) {
        try {
            ServiceController controller = container.getRequiredService(SERVICE_NAME);
            return (PackageAdmin)controller.getValue();
        }
        catch (ServiceNotFoundException ex) {
            throw new IllegalStateException("Cannot obtain required service: " + SERVICE_NAME);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            BundleContext sysContext = (BundleContext)this.injectedContext.getValue();
            ServiceReference sref = sysContext.getServiceReference(PackageAdmin.class.getName());
            this.packageAdmin = (PackageAdmin)sysContext.getService(sref);
        }
        catch (Throwable t) {
            throw new StartException("Failed to start PackageAdmin service", t);
        }
    }

    public synchronized void stop(StopContext context) {
    }

    public PackageAdmin getValue() throws IllegalStateException {
        return this.packageAdmin;
    }
}

