/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment;

import java.io.Closeable;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFSUtils;

public class DeploymentService
implements Service<Void> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment");
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"deployment"});
    private final Closeable deploymentMount;

    public DeploymentService(Closeable deploymentMount) {
        if (deploymentMount == null) {
            throw new IllegalArgumentException("deploymentMount is null");
        }
        this.deploymentMount = deploymentMount;
    }

    public static ServiceName getServiceName(String deploymentName) {
        return SERVICE_NAME.append(new String[]{deploymentName.replace('.', '_')});
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Start deployment service: %s", (Object)this.deploymentMount);
    }

    public void stop(StopContext context) {
        log.debugf("Stop deployment service: %s", (Object)this.deploymentMount);
        VFSUtils.safeClose((Closeable)this.deploymentMount);
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }
}

