/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.chain;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.as.deployment.chain.DeploymentChain;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

public class DeploymentChainProvider
implements Service<DeploymentChainProvider> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"deployment", "chain", "provider"});
    public static final DeploymentChainProvider INSTANCE = new DeploymentChainProvider();
    private final Set<OrderedChainSelector> selectors = new ConcurrentSkipListSet<OrderedChainSelector>();
    private final AtomicLong currentPriority = new AtomicLong(9999L);

    private DeploymentChainProvider() {
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public DeploymentChainProvider getValue() throws IllegalStateException {
        return this;
    }

    public DeploymentChain determineDeploymentChain(DeploymentUnitContext deploymentUnitContext) {
        for (OrderedChainSelector chainSelector : this.selectors) {
            if (!chainSelector.deploymentChainSelector.supports(deploymentUnitContext)) continue;
            return chainSelector.deploymentChain;
        }
        return null;
    }

    public void addDeploymentChain(DeploymentChain deploymentChain, Selector selector) {
        this.selectors.add(new OrderedChainSelector(deploymentChain, selector, this.currentPriority.getAndIncrement()));
    }

    public void addDeploymentChain(DeploymentChain deploymentChain, Selector selector, long priority) {
        this.selectors.add(new OrderedChainSelector(deploymentChain, selector, priority));
    }

    public void removeDeploymentChain(DeploymentChain deploymentChain, Selector selector, long priority) {
        this.selectors.remove(new OrderedChainSelector(deploymentChain, selector, priority));
    }

    private static class OrderedChainSelector
    implements Comparable<OrderedChainSelector> {
        private final DeploymentChain deploymentChain;
        private final Selector deploymentChainSelector;
        private final long priority;

        private OrderedChainSelector(DeploymentChain deploymentChain, Selector deploymentChainSelector, long priority) {
            this.deploymentChain = deploymentChain;
            this.deploymentChainSelector = deploymentChainSelector;
            this.priority = priority;
        }

        @Override
        public int compareTo(OrderedChainSelector other) {
            long thisOrder = this.priority;
            long otherOrder = other.priority;
            return thisOrder < otherOrder ? -1 : (thisOrder == otherOrder ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderedChainSelector that = (OrderedChainSelector)o;
            if (this.priority != that.priority) {
                return false;
            }
            if (this.deploymentChain != null ? !this.deploymentChain.equals(that.deploymentChain) : that.deploymentChain != null) {
                return false;
            }
            return !(this.deploymentChainSelector != null ? !this.deploymentChainSelector.equals(that.deploymentChainSelector) : that.deploymentChainSelector != null);
        }

        public int hashCode() {
            int result = this.deploymentChain != null ? this.deploymentChain.hashCode() : 0;
            result = 31 * result + (this.deploymentChainSelector != null ? this.deploymentChainSelector.hashCode() : 0);
            result = 31 * result + (int)(this.priority ^ this.priority >>> 32);
            return result;
        }
    }

    public static interface Selector {
        public boolean supports(DeploymentUnitContext var1);
    }

    public static class SelectorInjector<T extends Selector>
    implements Injector<DeploymentChainProvider> {
        private final Value<DeploymentChain> deploymentChainValue;
        private final Value<T> deploymentChainSelectorValue;
        private final long priority;
        private DeploymentChainProvider provider;

        public SelectorInjector(Value<DeploymentChain> deploymentChainValue, Value<T> deploymentChainSelectorValue, long priority) {
            this.deploymentChainValue = deploymentChainValue;
            this.deploymentChainSelectorValue = deploymentChainSelectorValue;
            this.priority = priority;
        }

        public void inject(DeploymentChainProvider provider) throws InjectionException {
            this.provider = provider;
            provider.addDeploymentChain((DeploymentChain)this.deploymentChainValue.getValue(), (Selector)this.deploymentChainSelectorValue.getValue(), this.priority);
        }

        public void uninject() {
            this.provider.removeDeploymentChain((DeploymentChain)this.deploymentChainValue.getValue(), (Selector)this.deploymentChainSelectorValue.getValue(), this.priority);
        }
    }
}

