/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.module;

import java.io.IOException;
import java.util.jar.Manifest;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.ManifestAttachment;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class ManifestAttachmentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(100L);

    @Override
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        Manifest manifest = ManifestAttachment.getManifestAttachment(context);
        if (manifest != null) {
            return;
        }
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment(context);
        try {
            manifest = VFSUtils.getManifest((VirtualFile)deploymentRoot);
            if (manifest != null) {
                ManifestAttachment.attachManifest(context, manifest);
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException("Failed to get manifest for deployment " + deploymentRoot, e);
        }
    }
}

