/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.module;

import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.module.ModuleConfig;
import org.jboss.as.deployment.module.ModuleDependencies;
import org.jboss.as.deployment.module.MountHandle;
import org.jboss.as.deployment.module.NestedMounts;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.vfs.VirtualFile;

public class ModuleConfigProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.MODULARIZE.plus(100L);
    private static final ModuleConfig.Dependency[] NO_DEPS = new ModuleConfig.Dependency[0];

    @Override
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        if (context.getAttachment(ModuleConfig.ATTACHMENT_KEY) != null) {
            return;
        }
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment(context);
        MountHandle rootMount = context.getAttachment(MountHandle.ATTACHMENT_KEY);
        NestedMounts mounts = context.getAttachment(NestedMounts.ATTACHMENT_KEY);
        ModuleIdentifier moduleIdentifier = ModuleIdentifier.create((String)("deployment." + deploymentRoot.getName()));
        int numMounts = mounts == null ? 1 : mounts.size() + 1;
        ModuleConfig.ResourceRoot[] resourceRoots = new ModuleConfig.ResourceRoot[numMounts];
        if (mounts != null) {
            int i = 1;
            for (NestedMounts.Entry entry : mounts) {
                resourceRoots[i++] = new ModuleConfig.ResourceRoot(entry.file(), entry.mount());
            }
        }
        resourceRoots[0] = new ModuleConfig.ResourceRoot(deploymentRoot, rootMount);
        ModuleDependencies dependenciesAttachment = ModuleDependencies.getAttachedDependencies(context);
        ModuleConfig.Dependency[] dependencies = dependenciesAttachment != null ? dependenciesAttachment.getDependencies() : NO_DEPS;
        ModuleConfig moduleConfig = new ModuleConfig(moduleIdentifier, dependencies, resourceRoots);
        context.putAttachment(ModuleConfig.ATTACHMENT_KEY, moduleConfig);
    }
}

