/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.module;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.module.MountHandle;
import org.jboss.as.deployment.module.NestedMounts;
import org.jboss.as.deployment.module.TempFileProviderService;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;

public class NestedJarInlineProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment");
    public static final long PRIORITY = DeploymentPhases.STRUCTURE.plus(100L);

    @Override
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment(context);
        final ArrayList list = new ArrayList(1);
        try {
            deploymentRoot.visit(new VirtualFileVisitor(){

                public void visit(VirtualFile virtualFile) {
                    if (virtualFile.getName().endsWith(".jar")) {
                        list.add(virtualFile);
                    }
                }

                public VisitorAttributes getAttributes() {
                    return VisitorAttributes.RECURSE_LEAVES_ONLY;
                }
            });
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException("Could not mount nested jars in deployment: " + deploymentRoot.getName(), e);
        }
        if (list.size() == 0) {
            return;
        }
        NestedMounts mounts = new NestedMounts(list.size());
        for (VirtualFile file : list) {
            try {
                MountHandle handle = new MountHandle(VFS.mountZip((VirtualFile)file, (VirtualFile)file, (TempFileProvider)TempFileProviderService.provider()));
                mounts.add(file, handle);
            }
            catch (IOException e) {
                log.warnf("Could not mount %s in deployment %s, skipping", (Object)file.getPathNameRelativeTo(deploymentRoot), (Object)deploymentRoot.getName());
            }
        }
        context.putAttachment(NestedMounts.ATTACHMENT_KEY, mounts);
        context.getBatchServiceBuilder().addListener((ServiceListener)new CloseListener(mounts.getClosables()));
    }

    static class CloseListener
    implements ServiceListener<Void> {
        private Closeable[] closeables;

        CloseListener(Closeable[] closeables) {
            this.closeables = closeables;
        }

        public void serviceStopped(ServiceController<? extends Void> controller) {
            if (this.closeables != null) {
                for (Closeable close : this.closeables) {
                    try {
                        close.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.closeables = null;
            }
        }

        public void listenerAdded(ServiceController<? extends Void> controller) {
        }

        public void serviceStarting(ServiceController<? extends Void> controller) {
        }

        public void serviceStarted(ServiceController<? extends Void> controller) {
        }

        public void serviceFailed(ServiceController<? extends Void> controller, StartException reason) {
        }

        public void serviceStopping(ServiceController<? extends Void> controller) {
        }

        public void serviceRemoved(ServiceController<? extends Void> controller) {
        }
    }
}

