/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.naming;

import javax.naming.Context;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.naming.ContextNames;
import org.jboss.as.deployment.naming.ContextService;
import org.jboss.as.deployment.naming.JndiName;
import org.jboss.as.deployment.naming.ModuleContextConfig;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class ModuleContextProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.INSTALL_SERVICES.plus(5L);

    @Override
    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        BatchBuilder batchBuilder = context.getBatchBuilder();
        ServiceName moduleContextServiceName = ContextNames.GLOBAL_CONTEXT_SERVICE_NAME.append(new String[]{context.getName()});
        JndiName moduleContextJndiName = ContextNames.GLOBAL_CONTEXT_NAME.append(context.getName());
        ContextService contextService = new ContextService(moduleContextJndiName);
        batchBuilder.addService(moduleContextServiceName, (Service)contextService).addDependency(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, Context.class, contextService.getParentContextInjector());
        context.putAttachment(ModuleContextConfig.ATTACHMENT_KEY, new ModuleContextConfig(moduleContextServiceName, moduleContextJndiName));
    }
}

