/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelRootElement;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Namespace;
import org.jboss.as.model.NamespacePrefix;
import org.jboss.as.model.SchemaLocation;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class AbstractModel<M extends AbstractModel<M>>
extends AbstractModelRootElement<M> {
    private static final long serialVersionUID = 66064050420378211L;
    private final String namespaceUri;
    private final Map<String, NamespacePrefix> prefixes = new LinkedHashMap<String, NamespacePrefix>();
    private final Map<String, SchemaLocation> schemaLocations = new LinkedHashMap<String, SchemaLocation>();
    private String noNamespaceSchemaLocation;

    protected AbstractModel(QName elementName) {
        super(elementName);
        String namespaceURI = elementName.getNamespaceURI();
        this.namespaceUri = namespaceURI == null ? "" : namespaceURI;
    }

    @Deprecated
    protected AbstractModel(XMLExtendedStreamReader reader) throws XMLStreamException {
        super(reader);
        String namespaceURI = reader.getNamespaceURI();
        this.namespaceUri = namespaceURI == null ? "" : namespaceURI;
    }

    public <R> void update(AbstractModelUpdate<M, R> update) throws UpdateFailedException {
        update.applyUpdate(this.cast());
    }

    protected void setPrefixes(Iterable<NamespacePrefix> prefixes) {
        Map<String, NamespacePrefix> prefixMap = this.prefixes;
        prefixMap.clear();
        for (NamespacePrefix prefix : prefixes) {
            String key;
            if (prefix == null || (key = prefix.getPrefix()) == null) continue;
            prefixMap.put(key, prefix);
        }
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getNamespaceUri(String prefix) {
        NamespacePrefix namespace = this.prefixes.get(prefix);
        return namespace == null ? null : namespace.getNamespaceURI();
    }

    public List<String> getPrefixNames() {
        return new ArrayList<String>(this.prefixes.keySet());
    }

    public List<NamespacePrefix> getPrefixes() {
        return new ArrayList<NamespacePrefix>(this.prefixes.values());
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    void setNoNamespaceSchemaLocation(String noNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = noNamespaceSchemaLocation;
    }

    void setSchemaLocations(Iterable<SchemaLocation> locations) {
        Map<String, SchemaLocation> locationMap = this.schemaLocations;
        locationMap.clear();
        for (SchemaLocation location : locations) {
            if (location == null) continue;
            String locationUri = location.getLocationUri();
            String namespaceUri = location.getNamespaceUri();
            if (locationUri == null || namespaceUri == null) continue;
            locationMap.put(namespaceUri, location);
        }
    }

    public List<SchemaLocation> getSchemaLocations() {
        return new ArrayList<SchemaLocation>(this.schemaLocations.values());
    }

    protected void writeNamespaces(XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeDefaultNamespace(this.namespaceUri);
        for (NamespacePrefix namespace : this.prefixes.values()) {
            writer.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
        }
        Iterator<SchemaLocation> it = this.schemaLocations.values().iterator();
        if (it.hasNext()) {
            StringBuilder str = new StringBuilder();
            do {
                SchemaLocation location = it.next();
                str.append(location.getNamespaceUri()).append(' ').append(location.getLocationUri());
                if (!it.hasNext()) continue;
                str.append(' ');
            } while (it.hasNext());
            writer.writeAttribute(Namespace.XML_SCHEMA_INSTANCE.getUriString(), Attribute.SCHEMA_LOCATION.getLocalName(), str.toString());
        }
        if (this.noNamespaceSchemaLocation != null) {
            writer.writeAttribute(Namespace.XML_SCHEMA_INSTANCE.getUriString(), Attribute.NO_NAMESPACE_SCHEMA_LOCATION.getLocalName(), this.noNamespaceSchemaLocation);
        }
    }
}

