/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DeploymentRepositoryElement
extends AbstractModelElement<DeploymentRepositoryElement> {
    private static final long serialVersionUID = -8564235225752540162L;
    public static final String DEFAULT_STANDALONE_PATH = "standalone/deployments";
    private final String name;
    private String path;
    private String relativeTo;
    private int interval = 0;
    private boolean enabled = true;

    public DeploymentRepositoryElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("path is null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    public void setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
    }

    public int getScanInterval() {
        return this.interval;
    }

    void setInterval(int interval) {
        this.interval = interval;
    }

    public boolean isScanEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    protected Class<DeploymentRepositoryElement> getElementClass() {
        return DeploymentRepositoryElement.class;
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.name != null) {
            streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        }
        if (this.interval != 0) {
            streamWriter.writeAttribute(Attribute.SCAN_INTERVAL.getLocalName(), String.valueOf(this.interval));
        }
        if (!this.enabled) {
            streamWriter.writeAttribute(Attribute.SCAN_ENABLED.getLocalName(), "false");
        }
        if (this.relativeTo != null) {
            streamWriter.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), this.relativeTo);
        }
        streamWriter.writeAttribute(Attribute.PATH.getLocalName(), this.path);
        streamWriter.writeEndElement();
    }
}

