/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.ParseUtils;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class DeploymentUnitElement
extends AbstractModelElement<DeploymentUnitElement>
implements ServiceActivator {
    private static final long serialVersionUID = 5335163070198512362L;
    private final String uniqueName;
    private final String runtimeName;
    private final byte[] sha1Hash;
    private boolean start;

    public static String bytesToHexString(byte[] bytes) {
        return AbstractModelElement.bytesToHexString(bytes);
    }

    public static byte[] hexStringToBytes(String hex) {
        return ParseUtils.hexStringToByteArray(hex);
    }

    public DeploymentUnitElement(String uniqueName, String runtimeName, byte[] sha1Hash, boolean start) {
        this.uniqueName = uniqueName;
        this.runtimeName = runtimeName;
        this.sha1Hash = sha1Hash;
        this.start = start;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public byte[] getSha1Hash() {
        byte[] copy = new byte[this.sha1Hash.length];
        System.arraycopy(this.sha1Hash, 0, copy, 0, this.sha1Hash.length);
        return copy;
    }

    public String getSha1HashAsHexString() {
        return DeploymentUnitElement.bytesToHexString(this.sha1Hash);
    }

    public boolean isStart() {
        return this.start;
    }

    void setStart(boolean start) {
        this.start = start;
    }

    public void activate(ServiceActivatorContext serviceActivatorContext) {
    }

    @Override
    protected Class<DeploymentUnitElement> getElementClass() {
        return DeploymentUnitElement.class;
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.uniqueName);
        streamWriter.writeAttribute(Attribute.RUNTIME_NAME.getLocalName(), this.runtimeName);
        streamWriter.writeAttribute(Attribute.SHA1.getLocalName(), DeploymentUnitElement.bytesToHexString(this.sha1Hash));
        if (!this.start) {
            streamWriter.writeAttribute(Attribute.START.getLocalName(), "false");
        }
        streamWriter.writeEndElement();
    }
}

