/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.DeploymentUnitElement;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerModelDeploymentFullReplaceUpdate;
import org.jboss.as.model.UpdateFailedException;

public final class DomainDeploymentFullReplaceUpdate
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String uniqueName;
    private final String runtimeName;
    private final byte[] hash;
    private final boolean start;

    public DomainDeploymentFullReplaceUpdate(String uniqueName, String runtimeName, byte[] hash, boolean start) {
        if (uniqueName == null) {
            throw new IllegalArgumentException("uniqueName is null");
        }
        if (runtimeName == null) {
            throw new IllegalArgumentException("runtimeName is null");
        }
        if (hash == null) {
            throw new IllegalArgumentException("hash is null");
        }
        this.uniqueName = uniqueName;
        this.runtimeName = runtimeName;
        this.hash = hash;
        this.start = start;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean isStart() {
        return this.start;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        if (!element.removeDeployment(this.uniqueName)) {
            throw new UpdateFailedException("Deployment '" + this.uniqueName + "' did not exist; cannot replace it");
        }
        DeploymentUnitElement due = new DeploymentUnitElement(this.uniqueName, this.runtimeName, this.hash, this.start);
        element.addDeployment(due);
        for (String groupName : element.getServerGroupNames()) {
            ServerGroupElement group = element.getServerGroup(groupName);
            ServerGroupDeploymentElement sgde = group.getDeployment(this.uniqueName);
            if (!group.removeDeployment(groupName)) continue;
            group.addDeployment(this.uniqueName, this.runtimeName, this.hash, sgde.isStart());
        }
    }

    public DomainDeploymentFullReplaceUpdate getCompensatingUpdate(DomainModel original) {
        DeploymentUnitElement due = original.getDeployment(this.uniqueName);
        return due == null ? null : new DomainDeploymentFullReplaceUpdate(this.uniqueName, due.getRuntimeName(), due.getSha1Hash(), due.isStart());
    }

    public ServerModelDeploymentFullReplaceUpdate getServerModelUpdate() {
        return new ServerModelDeploymentFullReplaceUpdate(this.uniqueName, this.runtimeName, this.hash, this.start);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        HashSet<String> groupNames = new HashSet<String>(domainModel.getServerGroupNames());
        Iterator it = groupNames.iterator();
        while (it.hasNext()) {
            String groupName = (String)it.next();
            ServerGroupElement group = domainModel.getServerGroup(groupName);
            ServerGroupDeploymentElement sgde = group.getDeployment(this.uniqueName);
            if (sgde != null) continue;
            it.remove();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String serverName : hostModel.getActiveServerNames()) {
            ServerElement server = hostModel.getServer(serverName);
            if (!groupNames.contains(server.getServerGroup())) continue;
            result.add(serverName);
        }
        return result;
    }
}

