/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainProfileIncludeRemove;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ProfileElement;
import org.jboss.as.model.UpdateFailedException;

public final class DomainProfileIncludeAdd
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -9076890219875153928L;
    private final String profileName;
    private final String includedProfileName;

    public DomainProfileIncludeAdd(String profileName, String includedProfileName) {
        this.profileName = profileName;
        this.includedProfileName = includedProfileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getIncludedProfileName() {
        return this.includedProfileName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        ProfileElement pe = element.getProfile(this.profileName);
        if (pe == null) {
            throw new UpdateFailedException("Profile '" + this.profileName + "' does not exist");
        }
        if (!pe.addIncludedProfile(this.includedProfileName)) {
            throw new UpdateFailedException("Profile '" + this.profileName + "' already includes profile '" + this.includedProfileName + "'");
        }
    }

    public DomainProfileIncludeRemove getCompensatingUpdate(DomainModel original) {
        return new DomainProfileIncludeRemove(this.profileName, this.includedProfileName);
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

