/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainServerGroupRemove;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.UpdateFailedException;

public final class DomainServerGroupAdd
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = 8526537198264820276L;
    private final String name;
    private final String profile;

    public DomainServerGroupAdd(String name, String profile) {
        this.name = name;
        this.profile = profile;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        if (!element.addServerGroup(this.name, this.profile)) {
            throw new UpdateFailedException("Duplicate server group " + this.name);
        }
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel original) {
        return new DomainServerGroupRemove(this.name);
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        return Collections.emptyList();
    }
}

