/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.DomainSocketBindingGroupAdd;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.SocketBindingGroupElement;
import org.jboss.as.model.socket.SocketBindingGroupUpdate;

public class DomainSocketBindingGroupRemove
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = 1L;
    private final String bindingGroupName;

    public DomainSocketBindingGroupRemove(String bindingGroupName) {
        this.bindingGroupName = bindingGroupName;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        StringBuilder illegal = null;
        for (String groupName : element.getServerGroupNames()) {
            ServerGroupElement sge = element.getServerGroup(groupName);
            if (!this.bindingGroupName.equals(sge.getSocketBindingGroupName())) continue;
            if (illegal == null) {
                illegal = new StringBuilder(groupName);
                continue;
            }
            illegal.append(", ");
            illegal.append(groupName);
        }
        if (illegal != null) {
            throw new UpdateFailedException(String.format("Socket binding group %s cannot be removed as it is referenced by server groups %s", this.bindingGroupName, illegal.toString()));
        }
        if (!element.removeBindingGroup(this.bindingGroupName)) {
            throw new UpdateFailedException(String.format("binding-group (%s) does not exist", this.bindingGroupName));
        }
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel domain) {
        SocketBindingGroupElement original = domain.getSocketBindingGroup(this.bindingGroupName);
        SocketBindingGroupUpdate update = new SocketBindingGroupUpdate(this.bindingGroupName, original.getDefaultInterface(), original.getIncludedSocketBindingGroups());
        return new DomainSocketBindingGroupAdd(update);
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        StringBuilder illegal = null;
        for (ServerElement server : hostModel.getServers()) {
            if (!this.bindingGroupName.equals(server.getSocketBindingGroupName())) continue;
            if (illegal == null) {
                illegal = new StringBuilder(server.getName());
                continue;
            }
            illegal.append(", ");
            illegal.append(server.getName());
        }
        if (illegal != null) {
            throw new UpdateFailedException(String.format("Socket binding group %s cannot be removed as it is referenced by servers %s", this.bindingGroupName, illegal.toString()));
        }
        return Collections.emptyList();
    }
}

