/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ProfileElement;
import org.jboss.as.model.ServerSubsystemUpdate;
import org.jboss.as.model.UpdateFailedException;

public final class DomainSubsystemUpdate<E extends AbstractSubsystemElement<E>, R>
extends AbstractDomainModelUpdate<R> {
    private static final long serialVersionUID = -7899677507905342444L;
    private final String profileName;
    private final AbstractSubsystemUpdate<E, R> update;

    public DomainSubsystemUpdate(String profileName, AbstractSubsystemUpdate<E, R> update) {
        this.profileName = profileName;
        this.update = update;
    }

    public static <E extends AbstractSubsystemElement<E>, R> DomainSubsystemUpdate<E, R> create(String profileName, AbstractSubsystemUpdate<E, R> update) {
        return new DomainSubsystemUpdate<E, R>(profileName, update);
    }

    public String getProfileName() {
        return this.profileName;
    }

    public AbstractSubsystemUpdate<?, ? extends R> getUpdate() {
        return this.update;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        ProfileElement profileElement = element.getProfile(this.profileName);
        String namespaceUri = this.update.getSubsystemNamespaceUri();
        AbstractSubsystemElement subsystemElement = (AbstractSubsystemElement)this.update.getModelElementType().cast(profileElement.getSubsystem(namespaceUri));
        if (subsystemElement == null) {
            throw new UpdateFailedException("No such subsystem '" + namespaceUri + "' declared on profile '" + this.profileName + "'");
        }
        this.update.applyUpdate(subsystemElement);
    }

    @Override
    public AbstractDomainModelUpdate<?> getCompensatingUpdate(DomainModel original) {
        String namespaceUri = this.update.getSubsystemNamespaceUri();
        AbstractSubsystemElement element = (AbstractSubsystemElement)this.update.getModelElementType().cast(original.getProfile(this.profileName).getSubsystem(namespaceUri));
        if (element == null) {
            throw new IllegalArgumentException("No such subsystem '" + namespaceUri + "' declared on profile '" + this.profileName + "'");
        }
        AbstractSubsystemUpdate<AbstractSubsystemElement, ?> compensatingUpdate = this.update.getCompensatingUpdate(element);
        return DomainSubsystemUpdate.createUpdate(this.profileName, compensatingUpdate);
    }

    private static <E extends AbstractSubsystemElement<E>, R> DomainSubsystemUpdate<E, R> createUpdate(String profileName, AbstractSubsystemUpdate<E, R> update) {
        return new DomainSubsystemUpdate<E, R>(profileName, update);
    }

    @Override
    public AbstractServerModelUpdate<R> getServerModelUpdate() {
        return new ServerSubsystemUpdate<E, R>(this.update);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        if (this.getServerModelUpdate() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, Set<String>> includedProfilesByRoot = new HashMap<String, Set<String>>();
        for (String server : hostModel.getActiveServerNames()) {
            String serverGroupName = hostModel.getServer(server).getServerGroup();
            String sgProfileName = domainModel.getServerGroup(serverGroupName).getProfileName();
            if (!includedProfilesByRoot.containsKey(sgProfileName)) {
                includedProfilesByRoot.put(sgProfileName, domainModel.getProfiles(sgProfileName).keySet());
            }
            if (!((Set)includedProfilesByRoot.get(sgProfileName)).contains(this.profileName)) continue;
            result.add(server);
        }
        return result;
    }
}

