/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.UpdateFailedException;

public final class HostExtensionRemove
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 6075488950873140885L;
    private final String moduleName;

    public HostExtensionRemove(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        if (!element.removeExtension(this.moduleName)) {
            throw new UpdateFailedException("Extension " + this.moduleName + " was not configured");
        }
    }

    public HostExtensionRemove getCompensatingUpdate(HostModel original) {
        if (original.getExtensions().contains(this.moduleName)) {
            return new HostExtensionRemove(this.moduleName);
        }
        return null;
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return Collections.emptyList();
    }
}

