/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostInterfaceAdd;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerModelInterfaceRemove;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.InterfaceAdd;
import org.jboss.as.model.socket.InterfaceElement;

public class HostInterfaceRemove
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = -857258938550699575L;
    private final String interfaceName;

    public HostInterfaceRemove(String name) {
        this.interfaceName = name;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        if (element.removeInterface(this.interfaceName)) {
            throw new UpdateFailedException(String.format("network interface (%s) not found", this.interfaceName));
        }
    }

    @Override
    public AbstractHostModelUpdate<?> getCompensatingUpdate(HostModel original) {
        InterfaceElement element = original.getInterface(this.interfaceName);
        if (element == null) {
            return null;
        }
        return new HostInterfaceAdd(new InterfaceAdd(element));
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerModelInterfaceRemove(this.interfaceName);
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return hostModel.getActiveServerNames();
    }
}

