/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.HostPathAdd;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.ServerPathRemove;
import org.jboss.as.model.UpdateFailedException;

public class HostPathRemove
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 8637955118179300666L;
    private final String name;

    public HostPathRemove(String name) {
        this.name = name;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        if (!element.removePath(this.name)) {
            throw new UpdateFailedException(String.format("path (%s) does not exist", this.name));
        }
    }

    @Override
    public AbstractHostModelUpdate<?> getCompensatingUpdate(HostModel original) {
        PathElement path = original.getPath(this.name);
        if (path == null) {
            return null;
        }
        return new HostPathAdd(new PathElementUpdate(this.name, path.getPath(), path.getRelativeTo()));
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return new ServerPathRemove(this.name);
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return Collections.emptyList();
    }
}

