/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.as.model.Namespace;
import org.jboss.as.model.ParseUtils;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class JvmOptionsElement
extends AbstractModelElement<JvmOptionsElement> {
    private static final long serialVersionUID = 1614693052895734582L;
    private final List<String> options = new ArrayList<String>();

    public JvmOptionsElement() {
    }

    public JvmOptionsElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == Element.OPTION) {
                        String value = null;
                        int count = reader.getAttributeCount();
                        block7: for (int i = 0; i < count; ++i) {
                            String attrValue = reader.getAttributeValue(i);
                            if (reader.getAttributeNamespace(i) != null) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case VALUE: {
                                    value = attrValue;
                                    continue block7;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute(reader, i);
                                }
                            }
                        }
                        this.addOption(value);
                        ParseUtils.requireNoContent(reader);
                        continue block6;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (this.options.size() == 0) {
            throw ParseUtils.missingRequiredElement(reader, Collections.singleton(Element.OPTION));
        }
    }

    public JvmOptionsElement(Element propertyType, boolean allowNullValue, JvmOptionsElement ... toCombine) {
        if (toCombine != null) {
            for (JvmOptionsElement pe : toCombine) {
                if (pe == null) continue;
                for (String value : pe.getOptions()) {
                    this.addOption(value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long elementHash() {
        List<String> list = this.options;
        synchronized (list) {
            return ((Object)this.options).hashCode();
        }
    }

    @Override
    protected Class<JvmOptionsElement> getElementClass() {
        return JvmOptionsElement.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement(Element.JVM_OPTIONS.getLocalName());
        List<String> list = this.options;
        synchronized (list) {
            for (String option : this.options) {
                streamWriter.writeEmptyElement(Element.OPTION.toString());
                streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), option);
            }
        }
        streamWriter.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOption(String value) {
        List<String> list = this.options;
        synchronized (list) {
            if (value == null) {
                throw new IllegalArgumentException("Value for jvm option is null");
            }
            this.options.add(value);
        }
    }

    public int size() {
        return this.options.size();
    }

    public List<String> getOptions() {
        return new ArrayList<String>(this.options);
    }
}

