/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.NamespacePrefix;
import org.jboss.as.model.Property;
import org.jboss.as.model.SchemaLocation;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class ParseUtils {
    private ParseUtils() {
    }

    public static XMLStreamException unexpectedElement(XMLExtendedStreamReader reader) {
        return new XMLStreamException("Unexpected element '" + reader.getName() + "' encountered", reader.getLocation());
    }

    public static XMLStreamException unexpectedEndElement(XMLExtendedStreamReader reader) {
        return new XMLStreamException("Unexpected end of element '" + reader.getName() + "' encountered", reader.getLocation());
    }

    public static XMLStreamException unexpectedAttribute(XMLExtendedStreamReader reader, int index) {
        return new XMLStreamException("Unexpected attribute '" + reader.getAttributeName(index) + "' encountered", reader.getLocation());
    }

    public static XMLStreamException invalidAttributeValue(XMLExtendedStreamReader reader, int index) {
        return new XMLStreamException("Invalid value '" + reader.getAttributeValue(index) + "' for attribute '" + reader.getAttributeName(index) + "'", reader.getLocation());
    }

    public static XMLStreamException missingRequired(XMLExtendedStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required attribute(s): " + b, reader.getLocation());
    }

    public static XMLStreamException missingRequiredElement(XMLExtendedStreamReader reader, Set<?> required) {
        StringBuilder b = new StringBuilder();
        Iterator<?> iterator = required.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            b.append(o.toString());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return new XMLStreamException("Missing required element(s): " + b, reader.getLocation());
    }

    public static void requireNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
    }

    public static void requireNoContent(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static XMLStreamException duplicateAttribute(XMLExtendedStreamReader reader, String name) {
        return new XMLStreamException("An attribute named '" + name + "' has already been declared", reader.getLocation());
    }

    public static XMLStreamException duplicateNamedElement(XMLExtendedStreamReader reader, String name) {
        return new XMLStreamException("An element of this type named '" + name + "' has already been declared", reader.getLocation());
    }

    public static boolean readBooleanAttributeElement(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        boolean value = Boolean.parseBoolean(reader.getAttributeValue(0));
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static String readStringAttributeElement(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        String value = reader.getAttributeValue(0);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static <T> List<T> readListAttributeElement(XMLExtendedStreamReader reader, String attributeName, Class<T> type) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, attributeName);
        List value = reader.getListAttributeValue(0, type);
        ParseUtils.requireNoContent(reader);
        return value;
    }

    public static <T> T[] readArrayAttributeElement(XMLExtendedStreamReader reader, String attributeName, Class<T> type) throws XMLStreamException {
        List<Object> list = ParseUtils.readListAttributeElement(reader, attributeName, type);
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    public static void requireSingleAttribute(XMLExtendedStreamReader reader, String attributeName) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(attributeName));
        }
        if (reader.getAttributeNamespace(0) != null || !attributeName.equals(reader.getAttributeLocalName(0))) {
            throw ParseUtils.unexpectedAttribute(reader, 0);
        }
        if (count > 1) {
            throw ParseUtils.unexpectedAttribute(reader, 1);
        }
    }

    public static List<SchemaLocation> readSchemaLocations(XMLExtendedStreamReader reader, int idx) throws XMLStreamException {
        List values = reader.getListAttributeValue(idx);
        if ((values.size() & 1) != 0) {
            throw ParseUtils.invalidAttributeValue(reader, idx);
        }
        Iterator it = values.iterator();
        ArrayList<SchemaLocation> locationList = new ArrayList<SchemaLocation>();
        while (it.hasNext()) {
            locationList.add(new SchemaLocation((String)it.next(), (String)it.next()));
        }
        return locationList;
    }

    public static List<NamespacePrefix> readNamespaces(XMLExtendedStreamReader reader) {
        int nsCount = reader.getNamespaceCount();
        if (nsCount > 0) {
            ArrayList<NamespacePrefix> prefixes = new ArrayList<NamespacePrefix>();
            for (int i = 0; i < nsCount; ++i) {
                String prefix = reader.getNamespacePrefix(i);
                if (prefix == null) continue;
                prefixes.add(new NamespacePrefix(prefix, reader.getNamespaceURI(i)));
            }
            return prefixes;
        }
        return Collections.emptyList();
    }

    public static Property readProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        int cnt = reader.getAttributeCount();
        String name = null;
        String value = null;
        for (int i = 0; i < cnt; ++i) {
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            String localName = reader.getAttributeLocalName(i);
            if (localName.equals("name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (localName.equals("value")) {
                value = reader.getAttributeValue(i);
                continue;
            }
            throw ParseUtils.unexpectedAttribute(reader, i);
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton("name"));
        }
        return new Property(name, value == null ? "" : value);
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int x = Character.digit(s.charAt(j), 16) << 4;
            x |= Character.digit(s.charAt(++j), 16);
            ++j;
            data[i] = (byte)(x & 0xFF);
            ++i;
        }
        return data;
    }
}

