/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class PathElement
extends AbstractModelElement<PathElement> {
    static final Set<String> RESTRICTED = new HashSet<String>(10);
    private static final long serialVersionUID = 5502158760122357895L;
    private final String name;
    private String path;
    private String relativeTo;

    protected PathElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (RESTRICTED.contains(name)) {
            throw new IllegalArgumentException("Illegal path name. Cannot be one of the standard fixed paths defined by the system.");
        }
        this.name = name;
    }

    @Override
    protected Class<PathElement> getElementClass() {
        return PathElement.class;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    void setPath(String path) {
        this.path = path;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    void setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
    }

    public boolean isAbsolutePath() {
        String relativeTo = this.relativeTo;
        return relativeTo == null;
    }

    public boolean isSpecified() {
        String path = this.path;
        return path != null;
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        if (this.path != null) {
            streamWriter.writeAttribute(Attribute.PATH.getLocalName(), this.path);
        }
        if (this.relativeTo != null) {
            streamWriter.writeAttribute(Attribute.RELATIVE_TO.getLocalName(), this.relativeTo);
        }
        streamWriter.writeEndElement();
    }

    static {
        RESTRICTED.add("jboss.home");
        RESTRICTED.add("jboss.home.dir");
        RESTRICTED.add("user.home");
        RESTRICTED.add("user.dir");
        RESTRICTED.add("java.home");
        RESTRICTED.add("jboss.server.base.dir");
        RESTRICTED.add("jboss.server.data.dir");
        RESTRICTED.add("jboss.server.log.dir");
        RESTRICTED.add("jboss.server.tmp.dir");
        RESTRICTED.add("jboss.modules.dir");
        RESTRICTED.add("jboss.server.deploy.dir");
        RESTRICTED.add("jboss.domain.servers.dir");
    }
}

