/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelElementUpdate;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.UpdateFailedException;

public class PathElementUpdate
extends AbstractModelElementUpdate<PathElement> {
    private static final long serialVersionUID = 7203735088855065479L;
    private final String name;
    private final String path;
    private final String relativeTo;

    public PathElementUpdate(String pathName, String path, String relativeTo) {
        if (pathName == null) {
            throw new IllegalArgumentException("null path name");
        }
        this.name = pathName;
        this.path = path;
        this.relativeTo = relativeTo;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    boolean isAbsolutePath() {
        return this.relativeTo == null;
    }

    @Override
    public Class<PathElement> getModelElementType() {
        return PathElement.class;
    }

    @Override
    protected void applyUpdate(PathElement element) throws UpdateFailedException {
        element.setPath(this.path);
        element.setRelativeTo(this.relativeTo);
    }

    @Override
    public AbstractModelElementUpdate<PathElement> getCompensatingUpdate(PathElement original) {
        return new PathElementUpdate(this.name, original.getPath(), original.getRelativeTo());
    }
}

