/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Map;
import java.util.Properties;
import org.jboss.as.model.AbstractPropertyUpdate;
import org.jboss.as.model.PropertiesElement;
import org.jboss.as.model.PropertyRemove;
import org.jboss.as.model.UpdateFailedException;

public final class PropertyAdd
extends AbstractPropertyUpdate {
    private static final long serialVersionUID = 5040034824081445679L;
    private final String value;

    public PropertyAdd(String name, String value) {
        super(name);
        this.value = value;
    }

    @Override
    protected void applyUpdate(PropertiesElement element) {
        element.addProperty(this.getPropertyName(), this.value);
    }

    @Override
    protected void applyUpdate(Properties properties) throws UpdateFailedException {
        properties.setProperty(this.getPropertyName(), this.value);
    }

    @Override
    protected void applyUpdate(Map<? super String, ? super String> map) {
        map.put(this.getPropertyName(), this.value);
    }

    @Override
    public AbstractPropertyUpdate getCompensatingUpdate(PropertiesElement original) {
        return new PropertyRemove(this.getPropertyName());
    }

    public String getValue() {
        return this.value;
    }
}

