/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.concurrent.TimeUnit;
import org.jboss.as.deployment.scanner.DeploymentScanner;
import org.jboss.as.deployment.scanner.DeploymentScannerService;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DeploymentRepositoryElement;
import org.jboss.as.model.ServerDeploymentRepositoryRemove;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;

public class ServerDeploymentRepositoryAdd
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = -1611269698053636197L;
    private static final String DEFAULT_NAME = "default";
    private final String path;
    private String name;
    private String relativeTo;
    private int interval = 0;
    private boolean enabled = true;

    public ServerDeploymentRepositoryAdd(String path, int interval, boolean enabled) {
        super(false, true);
        this.path = path;
        this.interval = interval;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRelativePath() {
        return this.relativeTo;
    }

    public void setRelativeTo(String relativePath) {
        this.relativeTo = relativePath;
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        String repositoryName = this.repositoryName();
        if (!element.addDeploymentRepository(repositoryName)) {
            throw new UpdateFailedException("duplicate deployment repository " + repositoryName);
        }
        DeploymentRepositoryElement repository = element.getDeploymentRepository(repositoryName);
        repository.setInterval(this.interval);
        repository.setEnabled(this.enabled);
        repository.setPath(this.path);
        repository.setRelativeTo(this.relativeTo);
    }

    @Override
    public AbstractServerModelUpdate<?> getCompensatingUpdate(ServerModel original) {
        return new ServerDeploymentRepositoryRemove(this.repositoryName());
    }

    @Override
    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        BatchBuilder batch = updateContext.getBatchBuilder();
        BatchServiceBuilder<DeploymentScanner> builder = DeploymentScannerService.addService(batch, this.repositoryName(), this.relativeTo, this.path, this.interval, TimeUnit.MILLISECONDS, this.enabled);
        builder.addListener(new UpdateResultHandler.ServiceStartListener<P>(resultHandler, param));
    }

    private String repositoryName() {
        return this.name != null ? this.name : DEFAULT_NAME;
    }
}

