/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.deployment.scanner.DeploymentScannerService;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DeploymentRepositoryElement;
import org.jboss.as.model.ServerDeploymentRepositoryAdd;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;

public class ServerDeploymentRepositoryRemove
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = -8749135039011134115L;
    private final String path;

    public ServerDeploymentRepositoryRemove(String path) {
        super(false, true);
        this.path = path;
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        if (!element.removeDeploymentRepository(this.path)) {
            throw new UpdateFailedException(String.format("deployment repository (%s) does not exist", this.path));
        }
    }

    @Override
    public AbstractServerModelUpdate<?> getCompensatingUpdate(ServerModel original) {
        DeploymentRepositoryElement repository = original.getDeploymentRepository(this.path);
        if (repository == null) {
            return null;
        }
        ServerDeploymentRepositoryAdd action = new ServerDeploymentRepositoryAdd(this.path, repository.getScanInterval(), repository.isScanEnabled());
        action.setName(repository.getName());
        action.setRelativeTo(repository.getRelativeTo());
        return action;
    }

    @Override
    public <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController controller = context.getServiceContainer().getService(DeploymentScannerService.getServiceName(this.path));
        if (controller == null) {
            resultHandler.handleSuccess(null, param);
            return;
        }
        controller.addListener(new UpdateResultHandler.ServiceRemoveListener<P>(resultHandler, param));
    }
}

