/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.UpdateFailedException;

public class ServerElementSocketBindingPortOffsetUpdate
extends AbstractModelUpdate<ServerElement, Void> {
    private static final long serialVersionUID = -5766717739615737224L;
    private final int offset;

    public ServerElementSocketBindingPortOffsetUpdate(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset " + offset + " is less than zero");
        }
        this.offset = offset;
    }

    public ServerElementSocketBindingPortOffsetUpdate getCompensatingUpdate(ServerElement original) {
        return new ServerElementSocketBindingPortOffsetUpdate(original.getSocketBindingPortOffset());
    }

    @Override
    protected AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    protected void applyUpdate(ServerElement element) throws UpdateFailedException {
        element.setSocketBindingPortOffset(this.offset);
    }

    @Override
    public Class<ServerElement> getModelElementType() {
        return ServerElement.class;
    }
}

