/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerModelDeploymentReplaceUpdate;
import org.jboss.as.model.UpdateFailedException;

public class ServerGroupDeploymentFullReplaceUpdate
extends AbstractModelUpdate<ServerGroupElement, Void> {
    private static final long serialVersionUID = 5773083013951607950L;
    private final String uniqueName;
    private final String runtimeName;
    private final byte[] hash;
    private final String replacedDeploymentName;

    public ServerGroupDeploymentFullReplaceUpdate(String uniqueName, String runtimeName, byte[] hash, String replacedDeploymentName) {
        if (uniqueName == null) {
            throw new IllegalArgumentException("uniqueName is null");
        }
        if (runtimeName == null) {
            throw new IllegalArgumentException("runtimeName is null");
        }
        if (hash == null) {
            throw new IllegalArgumentException("hash is null");
        }
        if (replacedDeploymentName == null) {
            throw new IllegalArgumentException("replacedDeploymentName is null");
        }
        this.uniqueName = uniqueName;
        this.runtimeName = runtimeName;
        this.hash = hash;
        this.replacedDeploymentName = replacedDeploymentName;
    }

    public ServerGroupDeploymentFullReplaceUpdate getCompensatingUpdate(ServerGroupElement original) {
        ServerGroupDeploymentElement toReplace = original.getDeployment(this.replacedDeploymentName);
        if (toReplace == null) {
            return null;
        }
        return new ServerGroupDeploymentFullReplaceUpdate(toReplace.getUniqueName(), toReplace.getRuntimeName(), toReplace.getSha1Hash(), this.uniqueName);
    }

    protected ServerModelDeploymentReplaceUpdate getServerModelUpdate() {
        return new ServerModelDeploymentReplaceUpdate(this.uniqueName, this.replacedDeploymentName);
    }

    @Override
    protected void applyUpdate(ServerGroupElement serverGroupElement) throws UpdateFailedException {
        ServerGroupDeploymentElement undeploymentElement = serverGroupElement.getDeployment(this.replacedDeploymentName);
        if (undeploymentElement == null) {
            throw new UpdateFailedException("Unknown deployment " + serverGroupElement);
        }
        ServerGroupDeploymentElement deploymentElement = serverGroupElement.getDeployment(this.uniqueName);
        if (deploymentElement == null) {
            throw new UpdateFailedException("Unknown deployment " + this.uniqueName);
        }
        undeploymentElement.setStart(false);
        deploymentElement.setStart(true);
    }

    @Override
    public Class<ServerGroupElement> getModelElementType() {
        return ServerGroupElement.class;
    }
}

