/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.JvmElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.UpdateFailedException;

public class ServerGroupJvmUpdate<R>
extends AbstractModelUpdate<ServerGroupElement, R> {
    private static final long serialVersionUID = 6228523925797316634L;
    private final AbstractModelUpdate<JvmElement, R> jvmUpdate;

    public static <T> ServerGroupJvmUpdate<T> create(AbstractModelUpdate<JvmElement, T> jvmUpdate) {
        return new ServerGroupJvmUpdate<T>(jvmUpdate);
    }

    public ServerGroupJvmUpdate(AbstractModelUpdate<JvmElement, R> jvmUpdate) {
        if (jvmUpdate == null) {
            throw new IllegalArgumentException("jvmUpdate is null");
        }
        this.jvmUpdate = jvmUpdate;
    }

    @Override
    public ServerGroupJvmUpdate<?> getCompensatingUpdate(ServerGroupElement original) {
        JvmElement jvm = original.getJvm();
        return jvm == null ? null : ServerGroupJvmUpdate.create(this.jvmUpdate.getCompensatingUpdate((AbstractModelElement)jvm));
    }

    @Override
    protected AbstractServerModelUpdate<R> getServerModelUpdate() {
        return null;
    }

    @Override
    protected void applyUpdate(ServerGroupElement element) throws UpdateFailedException {
        JvmElement jvm = element.getJvm();
        if (jvm == null) {
            throw new UpdateFailedException("Server group " + element.getName() + " has no JVM configured");
        }
        this.jvmUpdate.applyUpdate(jvm);
    }

    @Override
    public Class<ServerGroupElement> getModelElementType() {
        return ServerGroupElement.class;
    }
}

