/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.UpdateFailedException;

public class ServerGroupSocketBindingPortOffsetUpdate
extends AbstractModelUpdate<ServerGroupElement, Void> {
    private static final long serialVersionUID = -5766717739615737224L;
    private final int offset;

    public ServerGroupSocketBindingPortOffsetUpdate(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset " + offset + " is less than zero");
        }
        this.offset = offset;
    }

    public ServerGroupSocketBindingPortOffsetUpdate getCompensatingUpdate(ServerGroupElement original) {
        return new ServerGroupSocketBindingPortOffsetUpdate(original.getSocketBindingPortOffset());
    }

    @Override
    protected AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    protected void applyUpdate(ServerGroupElement element) throws UpdateFailedException {
        element.setSocketBindingPortOffset(this.offset);
    }

    @Override
    public Class<ServerGroupElement> getModelElementType() {
        return ServerGroupElement.class;
    }
}

