/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerDeploymentStartStopHandler;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;

public class ServerModelDeploymentFullReplaceUpdate
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = 5773083013951607950L;
    private final String deploymentUniqueName;
    private final String deploymentRuntimeName;
    private final byte[] hash;
    private final boolean redeploy;

    public ServerModelDeploymentFullReplaceUpdate(String deploymentUniqueName, String deploymentRuntimeName, byte[] hash, boolean redeploy) {
        super(false, true);
        if (deploymentUniqueName == null) {
            throw new IllegalStateException("deploymentUniqueName is null");
        }
        if (deploymentRuntimeName == null) {
            throw new IllegalStateException("deploymentRuntimeName is null");
        }
        if (hash == null) {
            throw new IllegalStateException("hash is null");
        }
        this.deploymentUniqueName = deploymentUniqueName;
        this.deploymentRuntimeName = deploymentRuntimeName;
        this.hash = hash;
        this.redeploy = redeploy;
    }

    @Override
    public void applyUpdate(ServerModel element) throws UpdateFailedException {
        ServerGroupDeploymentElement toRemove = element.getDeployment(this.deploymentUniqueName);
        if (toRemove != null) {
            element.removeDeployment(this.deploymentUniqueName);
        }
        element.addDeployment(new ServerGroupDeploymentElement(this.deploymentUniqueName, this.deploymentRuntimeName, this.hash, this.redeploy));
    }

    @Override
    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        if (this.redeploy) {
            ServerDeploymentStartStopHandler startStopHandler = new ServerDeploymentStartStopHandler();
            startStopHandler.redeploy(this.deploymentUniqueName, this.deploymentRuntimeName, this.hash, updateContext.getServiceContainer(), resultHandler, param);
        } else if (resultHandler != null) {
            resultHandler.handleSuccess(null, param);
        }
    }

    public ServerModelDeploymentFullReplaceUpdate getCompensatingUpdate(ServerModel original) {
        ServerGroupDeploymentElement deployment = original.getDeployment(this.deploymentUniqueName);
        if (deployment == null) {
            return null;
        }
        return new ServerModelDeploymentFullReplaceUpdate(this.deploymentUniqueName, deployment.getRuntimeName(), deployment.getSha1Hash(), this.redeploy);
    }
}

