/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.ServerModelDeploymentAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;

public class ServerModelDeploymentRemove
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = -3612085673646053177L;
    private final String deploymentName;

    public ServerModelDeploymentRemove(String deploymentName) {
        super(false, true);
        this.deploymentName = deploymentName;
    }

    @Override
    public void applyUpdate(ServerModel standalone) throws UpdateFailedException {
        ServerGroupDeploymentElement toRemove = standalone.getDeployment(this.deploymentName);
        if (toRemove != null) {
            if (toRemove.isStart()) {
                throw new UpdateFailedException("Cannot remove deployment " + this.deploymentName + " as its " + (Object)((Object)Attribute.START) + " attribute is 'true'. Deployment must be undeployed before removal.");
            }
            standalone.removeDeployment(this.deploymentName);
        }
    }

    @Override
    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        if (resultHandler != null) {
            resultHandler.handleSuccess(null, param);
        }
    }

    public ServerModelDeploymentAdd getCompensatingUpdate(ServerModel original) {
        ServerGroupDeploymentElement toRemove = original.getDeployment(this.deploymentName);
        if (toRemove == null) {
            return null;
        }
        return new ServerModelDeploymentAdd(toRemove.getUniqueName(), toRemove.getRuntimeName(), toRemove.getSha1Hash());
    }
}

