/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.ServerPathAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.path.AbstractPathService;
import org.jboss.msc.service.ServiceController;

public class ServerPathRemove
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = 6683732173045719685L;
    private final String name;

    public ServerPathRemove(String name) {
        super(true, false);
        this.name = name;
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        if (!element.removePath(this.name)) {
            throw new UpdateFailedException(String.format("path (%s) does not exist.", this.name));
        }
    }

    @Override
    public AbstractServerModelUpdate<?> getCompensatingUpdate(ServerModel original) {
        PathElement element = original.getPath(this.name);
        if (element == null) {
            return null;
        }
        PathElementUpdate update = new PathElementUpdate(this.name, element.getPath(), element.getRelativeTo());
        return new ServerPathAdd(update);
    }

    @Override
    public <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController controller = context.getServiceContainer().getService(AbstractPathService.pathNameOf(this.name));
        if (controller == null) {
            resultHandler.handleSuccess(null, param);
        } else {
            controller.addListener(new UpdateResultHandler.ServiceRemoveListener<P>(resultHandler, param));
        }
    }
}

