/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.socket;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.model.AbstractModelElementUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.model.socket.AbstractInterfaceCriteriaElement;
import org.jboss.as.model.socket.AbstractNetworkInterfaceUpdate;
import org.jboss.as.model.socket.InterfaceCriteria;
import org.jboss.as.model.socket.InterfaceElement;
import org.jboss.as.services.net.NetworkInterfaceBinding;
import org.jboss.as.services.net.NetworkInterfaceService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;

public final class InterfaceAdd
extends AbstractNetworkInterfaceUpdate {
    private static final long serialVersionUID = 2597565379666344003L;
    private final String name;
    private boolean anyLocalV4;
    private boolean anyLocalV6;
    private boolean anyLocal;
    private Collection<AbstractInterfaceCriteriaElement<?>> interfaceCriteria = Collections.emptySet();

    public InterfaceAdd(String name, boolean anyLocalV4, boolean anyLocalV6, boolean anyLocal, Collection<AbstractInterfaceCriteriaElement<?>> interfaceCriteria) {
        this.name = name;
        this.anyLocalV4 = anyLocalV4;
        this.anyLocalV6 = anyLocalV6;
        this.anyLocal = anyLocal;
        this.interfaceCriteria = interfaceCriteria;
    }

    public InterfaceAdd(InterfaceElement networkInterface) {
        this.name = networkInterface.getName();
        this.anyLocal = networkInterface.isAnyLocalAddress();
        this.anyLocalV4 = networkInterface.isAnyLocalV4Address();
        this.anyLocalV6 = networkInterface.isAnyLocalV6Address();
        this.interfaceCriteria = networkInterface.getCriteriaElements();
    }

    public String getName() {
        return this.name;
    }

    public boolean isFullySpecified() {
        return this.anyLocal || this.anyLocalV4 || this.anyLocalV6 || this.interfaceCriteria != null && this.interfaceCriteria.size() > 0;
    }

    @Override
    public void applyUpdate(InterfaceElement element) throws UpdateFailedException {
        if (this.interfaceCriteria != null && this.interfaceCriteria.size() > 0) {
            for (AbstractInterfaceCriteriaElement<?> criteria : this.interfaceCriteria) {
                element.addCriteria(criteria);
            }
        }
        if (this.anyLocal) {
            element.setAnyLocal(this.anyLocal);
        }
        if (this.anyLocalV4) {
            element.setAnyLocalV4(this.anyLocalV4);
        }
        if (this.anyLocalV6) {
            element.setAnyLocalV6(this.anyLocalV6);
        }
    }

    @Override
    public AbstractModelElementUpdate<InterfaceElement> getCompensatingUpdate(InterfaceElement original) {
        return null;
    }

    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        BatchBuilder batch = updateContext.getBatchBuilder();
        BatchServiceBuilder builder = batch.addService(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{this.name}), this.createInterfaceService()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.addListener(new UpdateResultHandler.ServiceStartListener<P>(resultHandler, param));
    }

    Service<NetworkInterfaceBinding> createInterfaceService() {
        HashSet<InterfaceCriteria> criteria = new HashSet<InterfaceCriteria>();
        for (AbstractInterfaceCriteriaElement<?> element : this.interfaceCriteria) {
            criteria.add(element.getInterfaceCriteria());
        }
        return new NetworkInterfaceService(this.name, this.anyLocalV4, this.anyLocalV6, this.anyLocal, new OverallInterfaceCriteria(criteria));
    }

    static final class OverallInterfaceCriteria
    implements InterfaceCriteria {
        private static final long serialVersionUID = -5417786897309925997L;
        private final Set<InterfaceCriteria> interfaceCriteria;

        public OverallInterfaceCriteria(Set<InterfaceCriteria> criteria) {
            this.interfaceCriteria = criteria;
        }

        @Override
        public boolean isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
            for (InterfaceCriteria criteria : this.interfaceCriteria) {
                if (criteria.isAcceptable(networkInterface, address)) continue;
                return false;
            }
            return true;
        }
    }
}

