/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.socket;

import java.net.InetAddress;
import org.jboss.as.model.AbstractSocketBindingUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.model.socket.SocketBindingElement;
import org.jboss.as.model.socket.SocketBindingGroupElement;
import org.jboss.as.model.socket.SocketBindingRemove;
import org.jboss.as.services.net.SocketBinding;
import org.jboss.as.services.net.SocketBindingService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;

public class SocketBindingAdd
extends AbstractSocketBindingUpdate {
    private static final long serialVersionUID = -4940876367809265620L;
    private final String name;
    private final String interfaceName;
    private final int port;
    private boolean fixedPort;
    private int multicastPort;
    private InetAddress multicastAddress;

    public SocketBindingAdd(String interfaceName, String name, int port) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("interfaceName is null");
        }
        this.interfaceName = interfaceName;
        this.name = name;
        this.port = port;
    }

    public SocketBindingAdd(SocketBindingElement original) {
        this.name = original.getName();
        this.port = original.getPort();
        this.fixedPort = original.isFixedPort();
        this.multicastPort = original.getMulticastPort();
        this.multicastAddress = original.getMulticastAddress();
        this.interfaceName = original.getInterfaceName();
    }

    @Override
    public AbstractSocketBindingUpdate getCompensatingUpdate(SocketBindingGroupElement original) {
        return new SocketBindingRemove(this.name);
    }

    @Override
    protected void applyUpdate(SocketBindingGroupElement group) throws UpdateFailedException {
        SocketBindingElement socketBinding = new SocketBindingElement(this.name, group.getDefaultInterface());
        socketBinding.setConfiguredInterfaceName(this.interfaceName);
        socketBinding.setFixedPort(this.fixedPort);
        socketBinding.setPort(this.port);
        socketBinding.setMulticastAddress(this.multicastAddress);
        if (this.multicastAddress != null) {
            socketBinding.setMulticastPort(this.multicastPort);
        }
        if (group.addSocketBinding(this.name, socketBinding)) {
            throw new UpdateFailedException(String.format("duplicate socket-binding (%s) in binding-group (%s)", this.name, group.getName()));
        }
    }

    @Override
    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        BatchBuilder batchBuilder = updateContext.getBatchBuilder();
        BatchServiceBuilder<SocketBinding> builder = SocketBindingService.addService(batchBuilder, this);
        UpdateResultHandler.ServiceStartListener<P> listener = new UpdateResultHandler.ServiceStartListener<P>(resultHandler, param);
        builder.addListener(listener);
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isFixedPort() {
        return this.fixedPort;
    }

    public void setFixedPort(boolean fixedPort) {
        this.fixedPort = fixedPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastPort(int multicastPort) {
        this.multicastPort = multicastPort;
    }

    public InetAddress getMulticastAddress() {
        return this.multicastAddress;
    }

    public void setMulticastAddress(InetAddress multicastAddress) {
        this.multicastAddress = multicastAddress;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }
}

