/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.socket;

import java.net.InetAddress;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SocketBindingElement
extends AbstractModelElement<SocketBindingElement> {
    private static final long serialVersionUID = 6868487634991345679L;
    private final String name;
    private int port;
    private boolean fixedPort;
    private int multicastPort;
    private InetAddress multicastAddress;
    private String interfaceName;
    private String defaultInterfaceName;

    public SocketBindingElement(String name, String defaultInterfaceName) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        if (defaultInterfaceName == null) {
            throw new IllegalArgumentException("defaultInterfaceName is null");
        }
        this.defaultInterfaceName = defaultInterfaceName;
    }

    public String getName() {
        return this.name;
    }

    public String getInterfaceName() {
        return this.interfaceName == null ? this.defaultInterfaceName : this.interfaceName;
    }

    public String getConfiguredInterfaceName() {
        return this.interfaceName;
    }

    void setConfiguredInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getDefaultInterfaceName() {
        return this.defaultInterfaceName;
    }

    void setDefaultInterfaceName(String defaultInterfaceName) {
        this.defaultInterfaceName = defaultInterfaceName;
    }

    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        if (this.multicastPort < 0 || this.multicastPort >= 65536) {
            throw new IllegalArgumentException("multicastPort must be between 1 and 65536");
        }
        this.port = port;
    }

    public boolean isFixedPort() {
        return this.fixedPort;
    }

    void setFixedPort(boolean fixedPort) {
        this.fixedPort = fixedPort;
    }

    public InetAddress getMulticastAddress() {
        return this.multicastAddress;
    }

    void setMulticastAddress(InetAddress multicastAddress) {
        if (multicastAddress != null && !multicastAddress.isMulticastAddress()) {
            throw new IllegalArgumentException(multicastAddress + " is not a multicast address");
        }
        this.multicastAddress = multicastAddress;
        if (this.multicastAddress == null) {
            this.multicastPort = -1;
        }
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    void setMulticastPort(int multicastPort) {
        if (multicastPort < 1 || multicastPort >= 65536) {
            throw new IllegalArgumentException("multicastPort must be between 1 and 65536");
        }
        this.multicastPort = multicastPort;
    }

    @Override
    protected Class<SocketBindingElement> getElementClass() {
        return SocketBindingElement.class;
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        if (this.interfaceName != null) {
            streamWriter.writeAttribute(Attribute.INTERFACE.getLocalName(), this.interfaceName);
        }
        if (this.port != 0) {
            streamWriter.writeAttribute(Attribute.PORT.getLocalName(), String.valueOf(this.port));
        }
        if (this.fixedPort) {
            streamWriter.writeAttribute(Attribute.FIXED_PORT.getLocalName(), "true");
        }
        if (this.multicastAddress != null) {
            streamWriter.writeAttribute(Attribute.MULTICAST_ADDRESS.getLocalName(), this.multicastAddress.getHostAddress());
        }
        if (this.multicastPort != -1) {
            streamWriter.writeAttribute(Attribute.MULTICAST_PORT.getLocalName(), String.valueOf(this.multicastPort));
        }
        streamWriter.writeEndElement();
    }
}

