/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.socket;

import org.jboss.as.model.AbstractSocketBindingUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.model.socket.SocketBindingAdd;
import org.jboss.as.model.socket.SocketBindingElement;
import org.jboss.as.model.socket.SocketBindingGroupElement;
import org.jboss.as.services.net.SocketBinding;
import org.jboss.msc.service.ServiceController;

public class SocketBindingRemove
extends AbstractSocketBindingUpdate {
    private static final long serialVersionUID = -4506224971076132988L;
    private final String name;

    public SocketBindingRemove(String name) {
        this.name = name;
    }

    @Override
    public AbstractSocketBindingUpdate getCompensatingUpdate(SocketBindingGroupElement original) {
        SocketBindingElement element = original.getSocketBinding(this.name);
        return new SocketBindingAdd(element);
    }

    @Override
    protected void applyUpdate(SocketBindingGroupElement element) throws UpdateFailedException {
        element.removeSocketBinding(this.name);
    }

    @Override
    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController controller = updateContext.getServiceContainer().getService(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{this.name}));
        if (controller == null) {
            resultHandler.handleSuccess(null, param);
            return;
        }
        controller.addListener(new UpdateResultHandler.ServiceRemoveListener<P>(resultHandler, param));
    }
}

