/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.services.path;

import java.io.File;
import org.jboss.as.services.path.AbstractPathService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class AbsolutePathService
extends AbstractPathService {
    private final String absolutePath;

    public static BatchServiceBuilder<String> addService(String name, String abstractPath, BatchBuilder batchBuilder) {
        return AbsolutePathService.addService(AbsolutePathService.pathNameOf(name), abstractPath, batchBuilder);
    }

    public static BatchServiceBuilder<String> addService(ServiceName sname, String abstractPath, BatchBuilder batchBuilder) {
        AbsolutePathService service = new AbsolutePathService(abstractPath);
        return batchBuilder.addService(sname, (Service)service);
    }

    public AbsolutePathService(String abstractPath) {
        if (abstractPath == null) {
            throw new IllegalArgumentException("abstractPath is null");
        }
        if (abstractPath.length() == 0) {
            throw new IllegalArgumentException("abstractPath is empty");
        }
        File f = new File(abstractPath);
        this.absolutePath = f.getAbsolutePath();
    }

    @Override
    protected String resolvePath() {
        return this.absolutePath;
    }
}

