/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.jboss.ejb3.annotation.Consumer;
import org.jboss.ejb3.annotation.Service;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.AbstractCreator;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.web.WebComponentProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Web30MetaDataCreator
extends AbstractCreator<WebMetaData>
implements Creator<Collection<Class<?>>, Web30MetaData> {
    private static final Set<Class<? extends Annotation>> ignoreTypeAnnotations;
    private static final Logger log;

    public Web30MetaDataCreator(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addProcessor(new WebComponentProcessor(finder));
    }

    public Web30MetaData create(Collection<Class<?>> classes) {
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        Web30MetaData metaData = this.create();
        this.processMetaData(classes, (Object)metaData);
        return metaData;
    }

    protected Web30MetaData create() {
        Web30MetaData metaData = new Web30MetaData();
        metaData.setVersion("3.0");
        return metaData;
    }

    protected boolean validateClass(Class<?> clazz) {
        boolean trace = log.isTraceEnabled();
        for (Class<? extends Annotation> annotation : ignoreTypeAnnotations) {
            if (this.finder.getAnnotation(clazz, annotation) == null) continue;
            if (trace) {
                log.trace((Object)("won't process class: " + clazz + ", because of the type annotation: " + annotation));
            }
            return false;
        }
        return true;
    }

    static {
        log = Logger.getLogger(Web30MetaDataCreator.class);
        ignoreTypeAnnotations = new HashSet<Class<? extends Annotation>>();
        ignoreTypeAnnotations.add(Stateful.class);
        ignoreTypeAnnotations.add(Stateless.class);
        ignoreTypeAnnotations.add(MessageDriven.class);
        ignoreTypeAnnotations.add(Service.class);
        ignoreTypeAnnotations.add(Consumer.class);
    }
}

