/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.ccm;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.jca.core.connectionmanager.ConnectionRecord;
import org.jboss.jca.core.connectionmanager.ccm.KeyConnectionAssociation;
import org.jboss.jca.core.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.transaction.TransactionSynchronizer;
import org.jboss.jca.spi.ComponentStack;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;
import org.jboss.tm.usertx.UserTransactionListener;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;
import org.jboss.util.Strings;

public class CachedConnectionManager
implements ServerVMClientUserTransaction.UserTransactionStartedListener,
UserTransactionListener,
ComponentStack {
    private static Logger log = Logger.getLogger(CachedConnectionManager.class);
    private static boolean trace = log.isTraceEnabled();
    private static boolean debug = false;
    private static boolean error = false;
    private final TransactionManager transactionManager;
    private final ThreadLocal<LinkedList<Object>> currentObjects = new ThreadLocal();
    private final ConcurrentMap<KeyConnectionAssociation, ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>>> objectToConnectionManagerMap = new ConcurrentHashMap<KeyConnectionAssociation, ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>>>();
    private Map<Object, Throwable> connectionStackTraces = new WeakHashMap<Object, Throwable>();

    public CachedConnectionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void userTransactionStarted() throws SystemException {
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (trace) {
            log.trace((Object)("user tx started, key: " + key));
        }
        if (key == null) {
            return;
        }
        ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
        for (Map.Entry entry : cmToConnectionsMap.entrySet()) {
            ConnectionCacheListener cm = (ConnectionCacheListener)entry.getKey();
            CopyOnWriteArrayList conns = (CopyOnWriteArrayList)entry.getValue();
            cm.transactionStarted(conns);
        }
    }

    KeyConnectionAssociation peekMetaAwareObject() {
        LinkedList<Object> stack = this.currentObjects.get();
        if (stack == null) {
            return null;
        }
        if (!stack.isEmpty()) {
            return (KeyConnectionAssociation)stack.getLast();
        }
        return null;
    }

    public void popMetaAwareObject(Set unsharableResources) throws ResourceException {
        LinkedList<Object> stack = this.currentObjects.get();
        KeyConnectionAssociation oldKey = (KeyConnectionAssociation)stack.removeLast();
        if (trace) {
            log.trace((Object)("popped object: " + Strings.defaultToString((Object)oldKey)));
        }
        if (!stack.contains(oldKey)) {
            this.disconnect(oldKey, unsharableResources);
        }
        if (debug && this.closeAll(oldKey.getCMToConnectionsMap()) && error) {
            throw new ResourceException("Some connections were not closed, see the log for the allocation stacktraces");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnection(ConnectionCacheListener cm, ConnectionListener cl, Object connection, ConnectionRequestInfo cri) {
        if (debug) {
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.put(connection, new Throwable("STACKTRACE"));
            }
        }
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (trace) {
            log.trace((Object)("registering connection from connection manager " + cm + ", connection : " + connection + ", key: " + key));
        }
        if (key == null) {
            return;
        }
        ConnectionRecord cr = new ConnectionRecord(cl, connection, cri);
        ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
        CopyOnWriteArrayList<ConnectionRecord> conns = (CopyOnWriteArrayList<ConnectionRecord>)cmToConnectionsMap.get(cm);
        if (conns == null) {
            conns = new CopyOnWriteArrayList<ConnectionRecord>();
            cmToConnectionsMap.put(cm, conns);
        }
        conns.add(cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnection(ConnectionCacheListener cm, Object connection) {
        if (debug) {
            CloseConnectionSynchronization cas = this.getCloseConnectionSynchronization(false);
            if (cas != null) {
                cas.remove(connection);
            }
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.remove(connection);
            }
        }
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (trace) {
            log.trace((Object)("unregistering connection from connection manager " + cm + ", object: " + connection + ", key: " + key));
        }
        if (key == null) {
            return;
        }
        ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
        CopyOnWriteArrayList conns = (CopyOnWriteArrayList)cmToConnectionsMap.get(cm);
        if (conns == null) {
            return;
        }
        Iterator i = conns.iterator();
        while (i.hasNext()) {
            if (((ConnectionRecord)i.next()).getConnection() != connection) continue;
            i.remove();
            return;
        }
        throw new IllegalStateException("Trying to return an unknown connection2! " + connection);
    }

    public void pushMetaAwareObject(Object rawKey, Set unsharableResources) throws ResourceException {
        LinkedList<Object> stack = this.currentObjects.get();
        if (stack == null) {
            if (trace) {
                log.trace((Object)("new stack for key: " + Strings.defaultToString((Object)rawKey)));
            }
            stack = new LinkedList();
            this.currentObjects.set(stack);
        } else if (trace) {
            log.trace((Object)("old stack for key: " + Strings.defaultToString((Object)rawKey)));
        }
        KeyConnectionAssociation key = new KeyConnectionAssociation(rawKey);
        if (!stack.contains(key)) {
            this.reconnect(key, unsharableResources);
        }
        stack.addLast(key);
    }

    private void reconnect(KeyConnectionAssociation key, Set unsharableResources) throws ResourceException {
        ConcurrentMap cmToConnectionsMap = (ConcurrentMap)this.objectToConnectionManagerMap.get(key);
        if (cmToConnectionsMap == null) {
            return;
        }
        key.setCMToConnectionsMap(cmToConnectionsMap);
        for (Map.Entry entry : cmToConnectionsMap.entrySet()) {
            ConnectionCacheListener cm = (ConnectionCacheListener)entry.getKey();
            CopyOnWriteArrayList conns = (CopyOnWriteArrayList)entry.getValue();
            cm.reconnect(conns, unsharableResources);
        }
    }

    private void disconnect(KeyConnectionAssociation key, Set unsharableResources) throws ResourceException {
        ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
        if (!cmToConnectionsMap.isEmpty()) {
            this.objectToConnectionManagerMap.put(key, cmToConnectionsMap);
            for (Map.Entry entry : cmToConnectionsMap.entrySet()) {
                ConnectionCacheListener cm = (ConnectionCacheListener)entry.getKey();
                CopyOnWriteArrayList conns = (CopyOnWriteArrayList)entry.getValue();
                cm.disconnect(conns, unsharableResources);
            }
        }
    }

    public void unregisterConnectionCacheListener(ConnectionCacheListener cm) {
        if (trace) {
            log.trace((Object)("unregisterConnectionCacheListener: " + cm));
        }
        for (ConcurrentMap cmToConnectionsMap : this.objectToConnectionManagerMap.values()) {
            if (cmToConnectionsMap == null) continue;
            cmToConnectionsMap.remove(cm);
        }
    }

    private boolean closeAll(ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap) {
        if (!debug) {
            return false;
        }
        boolean unclosed = false;
        Collection connections = cmToConnectionsMap.values();
        if (connections.size() != 0) {
            for (CopyOnWriteArrayList conns : connections) {
                Iterator j = conns.iterator();
                while (j.hasNext()) {
                    Object c = ((ConnectionRecord)j.next()).getConnection();
                    CloseConnectionSynchronization cas = this.getCloseConnectionSynchronization(true);
                    if (cas == null) {
                        unclosed = true;
                        this.closeConnection(c);
                        continue;
                    }
                    cas.add(c);
                }
            }
        }
        return unclosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseConnectionSynchronization getCloseConnectionSynchronization(boolean createIfNotFound) {
        block7: {
            CloseConnectionSynchronization closeConnectionSynchronization;
            Transaction tx = null;
            if (this.transactionManager != null) {
                tx = this.transactionManager.getTransaction();
            }
            if (tx == null) break block7;
            TransactionSynchronizer.lock(tx);
            try {
                CloseConnectionSynchronization cas = (CloseConnectionSynchronization)TransactionSynchronizer.getCCMSynchronization(tx);
                if (cas == null && createIfNotFound && TxUtils.isActive((Transaction)tx)) {
                    cas = new CloseConnectionSynchronization();
                    TransactionSynchronizer.registerCCMSynchronization(tx, cas);
                }
                closeConnectionSynchronization = cas;
            }
            catch (Throwable throwable) {
                try {
                    TransactionSynchronizer.unlock(tx);
                    throw throwable;
                }
                catch (Throwable t) {
                    log.debug((Object)"Unable to synchronize with transaction", t);
                }
            }
            TransactionSynchronizer.unlock(tx);
            return closeConnectionSynchronization;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Object connectionHandle) {
        try {
            Throwable exception;
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                exception = this.connectionStackTraces.remove(connectionHandle);
            }
            Method m = connectionHandle.getClass().getMethod("close", new Class[0]);
            try {
                if (exception != null) {
                    log.info((Object)("Closing a connection for you.  Please close them yourself: " + connectionHandle), exception);
                } else {
                    log.info((Object)("Closing a connection for you.  Please close them yourself: " + connectionHandle));
                }
                m.invoke(connectionHandle, new Object[0]);
            }
            catch (Throwable t) {
                log.info((Object)"Throwable trying to close a connection for you, please close it yourself", t);
            }
        }
        catch (NoSuchMethodException nsme) {
            log.info((Object)"Could not find a close method on alleged connection objects.  Please close your own connections.");
        }
    }

    private class CloseConnectionSynchronization
    implements Synchronization {
        CopyOnWriteArraySet<Object> connections = new CopyOnWriteArraySet();
        AtomicBoolean closing = new AtomicBoolean(false);

        public void add(Object c) {
            if (this.closing.get()) {
                return;
            }
            this.connections.add(c);
        }

        public void remove(Object c) {
            if (this.closing.get()) {
                return;
            }
            this.connections.remove(c);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.closing.set(true);
            Iterator<Object> i = this.connections.iterator();
            while (i.hasNext()) {
                CachedConnectionManager.this.closeConnection(i.next());
            }
            this.connections.clear();
        }
    }
}

