/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.listener;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.jca.common.JBossResourceException;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.AbstractConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.transaction.TransactionSynchronizer;
import org.jboss.jca.core.connectionmanager.tx.TxConnectionManagerImpl;
import org.jboss.jca.core.connectionmanager.xa.LocalXAResource;
import org.jboss.tm.TxUtils;

public class TxConnectionListener
extends AbstractConnectionListener {
    private TransactionSynchronization transactionSynchronization;
    private final XAResource xaResource;
    private AtomicBoolean localTransaction = new AtomicBoolean(false);

    public TxConnectionListener(ConnectionManager cm, ManagedConnection mc, Pool pool, Object context, XAResource xaResource) throws ResourceException {
        super(cm, mc, pool, context);
        this.xaResource = xaResource;
        if (xaResource instanceof LocalXAResource) {
            ((LocalXAResource)xaResource).setConnectionListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enlist() throws SystemException {
        TransactionManager tm = this.getConnectionManager().getTransactionManager();
        int status = tm.getStatus();
        if (status == 6) {
            if (this.transactionSynchronization != null && this.transactionSynchronization.currentTx != null) {
                String error = "Attempt to use connection outside a transaction when already a tx!";
                if (this.trace) {
                    this.getLog().trace((Object)(error + " " + this));
                }
                throw new IllegalStateException(error);
            }
            if (this.trace) {
                this.getLog().trace((Object)("No transaction, no need to enlist: " + this));
            }
            return;
        }
        Transaction threadTx = tm.getTransaction();
        if (threadTx == null || status != 0) {
            String error = "Transaction " + threadTx + " is not active " + TxUtils.getStatusAsString((int)status);
            if (this.trace) {
                this.getLog().trace((Object)(error + " cl=" + this));
            }
            throw new IllegalStateException(error);
        }
        if (this.trace) {
            this.getLog().trace((Object)("Pre-enlist: " + this + " threadTx=" + threadTx));
        }
        TransactionSynchronization ourSynchronization = null;
        TransactionSynchronizer synchronizer = null;
        TransactionSynchronizer.lock(threadTx);
        try {
            if (!this.isTrackByTx() && this.transactionSynchronization != null) {
                String error = "Can't enlist - already a tx!";
                if (this.trace) {
                    this.getLog().trace((Object)(error + " " + this));
                }
                throw new IllegalStateException(error);
            }
            if (this.transactionSynchronization != null && !this.transactionSynchronization.currentTx.equals(threadTx)) {
                String error = "Trying to change transaction " + threadTx + " in enlist!";
                if (this.trace) {
                    this.getLog().trace((Object)(error + " " + this));
                }
                throw new IllegalStateException(error);
            }
            try {
                if (this.trace) {
                    this.getLog().trace((Object)("Get synchronizer " + this + " threadTx=" + threadTx));
                }
                synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(threadTx);
            }
            catch (Throwable t) {
                this.setTrackByTx(false);
                TxConnectionManagerImpl.rethrowAsSystemException("Cannot register synchronization", threadTx, t);
            }
            if (this.transactionSynchronization == null) {
                TransactionSynchronization synchronization = new TransactionSynchronization(threadTx, this.isTrackByTx());
                synchronizer.addUnenlisted(synchronization);
                this.transactionSynchronization = synchronization;
            }
            ourSynchronization = this.transactionSynchronization;
        }
        finally {
            TransactionSynchronizer.unlock(threadTx);
        }
        CopyOnWriteArrayList<Synchronization> unenlisted = synchronizer.getUnenlisted();
        if (unenlisted != null) {
            try {
                int size = unenlisted.size();
                for (int i = 0; i < size; ++i) {
                    TransactionSynchronization sync = (TransactionSynchronization)unenlisted.get(i);
                    if (!sync.enlist()) continue;
                    synchronizer.addEnlisted(sync);
                }
            }
            finally {
                synchronizer.enlisted();
            }
        }
        if (this.trace) {
            this.getLog().trace((Object)("Check enlisted " + this + " threadTx=" + threadTx));
        }
        ourSynchronization.checkEnlisted();
    }

    @Override
    public void delist() throws ResourceException {
        if (this.trace) {
            this.getLog().trace((Object)("delisting " + this));
        }
        try {
            if (!this.isTrackByTx() && this.transactionSynchronization != null) {
                Transaction tx = this.transactionSynchronization.currentTx;
                TransactionSynchronization synchronization = this.transactionSynchronization;
                this.transactionSynchronization = null;
                if (TxUtils.isUncommitted((Transaction)tx)) {
                    TransactionSynchronizer synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(tx);
                    if (synchronization.enlisted) {
                        synchronizer.removeEnlisted(synchronization);
                    }
                    if (!tx.delistResource(this.getXAResource(), 0x2000000)) {
                        throw new ResourceException("Failure to delist resource: " + this);
                    }
                }
            }
        }
        catch (Throwable t) {
            JBossResourceException.rethrowAsResourceException((String)"Error in delist!", (Throwable)t);
        }
    }

    protected XAResource getXAResource() {
        return this.xaResource;
    }

    @Override
    public void connectionClosed(ConnectionEvent ce) {
        if (this.trace) {
            this.getLog().trace((Object)("connectionClosed called mc=" + this.getManagedConnection()));
        }
        if (this.getManagedConnection() != (ManagedConnection)ce.getSource()) {
            throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection! Expected: " + this.getManagedConnection() + ", actual: " + ce.getSource());
        }
        if (this.getCachedConnectionManager() != null) {
            try {
                this.getCachedConnectionManager().unregisterConnection(this.getConnectionManager(), ce.getConnectionHandle());
            }
            catch (Throwable t) {
                this.getLog().info((Object)"throwable from unregister connection", t);
            }
        }
        try {
            if (this.wasFreed(ce.getConnectionHandle())) {
                this.delist();
                if (this.trace) {
                    this.getLog().trace((Object)("isManagedConnectionFree=true mc=" + this.getManagedConnection()));
                }
                this.getConnectionManager().returnManagedConnection(this, false);
            } else if (this.trace) {
                this.getLog().trace((Object)("isManagedConnectionFree=false mc=" + this.getManagedConnection()));
            }
        }
        catch (Throwable t) {
            this.getLog().error((Object)"Error while closing connection handle!", t);
            this.getConnectionManager().returnManagedConnection(this, true);
        }
    }

    @Override
    public void localTransactionStarted(ConnectionEvent ce) {
        this.localTransaction.set(true);
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent ce) {
        this.localTransaction.set(false);
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent ce) {
        this.localTransaction.set(false);
    }

    @Override
    public void tidyup() throws ResourceException {
        if (this.localTransaction.get()) {
            LocalTransaction local = null;
            ManagedConnection mc = this.getManagedConnection();
            try {
                local = mc.getLocalTransaction();
            }
            catch (Throwable t) {
                JBossResourceException.rethrowAsResourceException((String)("Unfinished local transaction - error getting local transaction from " + this), (Throwable)t);
            }
            if (local == null) {
                throw new ResourceException("Unfinished local transaction but managed connection does not provide a local transaction. " + this);
            }
            local.rollback();
            this.getLog().debug((Object)("Unfinished local transaction was rolled back." + this));
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent ce) {
        this.transactionSynchronization = null;
        super.connectionErrorOccurred(ce);
    }

    @Override
    public boolean isManagedConnectionFree() {
        if (this.isTrackByTx() && this.transactionSynchronization != null) {
            return false;
        }
        return super.isManagedConnectionFree();
    }

    synchronized boolean wasFreed(Object handle) {
        if (handle != null) {
            if (this.isManagedConnectionFree()) {
                return false;
            }
            this.getConnectionManager().unregisterAssociation(this, handle);
        } else {
            if (!this.isTrackByTx()) {
                return false;
            }
            this.setTrackByTx(false);
        }
        return this.isManagedConnectionFree();
    }

    @Override
    protected void toString(StringBuffer buffer) {
        buffer.append(" xaResource=").append(this.xaResource);
        buffer.append(" txSync=").append(this.transactionSynchronization);
    }

    private class TransactionSynchronization
    implements Synchronization {
        private final Throwable failedToEnlist = new Throwable("Unabled to enlist resource, see the previous warnings.");
        private final Transaction currentTx;
        private final boolean wasTrackByTx;
        private boolean enlisted;
        private Throwable enlistError;

        public TransactionSynchronization(Transaction tx, boolean trackByTx) {
            this.currentTx = tx;
            this.wasTrackByTx = trackByTx;
            this.enlisted = false;
            this.enlistError = null;
        }

        public void checkEnlisted() throws SystemException {
            if (this.enlistError != null) {
                String error = "Error enlisting resource in transaction=" + this.currentTx;
                if (TxConnectionListener.this.trace) {
                    TxConnectionListener.this.getLog().trace((Object)(error + " " + TxConnectionListener.this));
                }
                if (this.enlistError == this.failedToEnlist) {
                    throw new SystemException(this.failedToEnlist + " tx=" + this.currentTx);
                }
                SystemException e = new SystemException(error);
                e.initCause(this.enlistError);
                throw e;
            }
            if (!this.enlisted) {
                String error = "Resource is not enlisted in transaction=" + this.currentTx;
                if (TxConnectionListener.this.trace) {
                    TxConnectionListener.this.getLog().trace((Object)(error + " " + TxConnectionListener.this));
                }
                throw new IllegalStateException("Resource was not enlisted.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean enlist() {
            if (TxConnectionListener.this.trace) {
                TxConnectionListener.this.getLog().trace((Object)("Enlisting resource " + TxConnectionListener.this));
            }
            try {
                XAResource resource = TxConnectionListener.this.getXAResource();
                if (!this.currentTx.enlistResource(resource)) {
                    this.enlistError = this.failedToEnlist;
                }
            }
            catch (Throwable t) {
                this.enlistError = t;
            }
            TransactionSynchronization transactionSynchronization = this;
            synchronized (transactionSynchronization) {
                if (this.enlistError != null) {
                    if (TxConnectionListener.this.trace) {
                        TxConnectionListener.this.getLog().trace((Object)("Failed to enlist resource " + TxConnectionListener.this), this.enlistError);
                    }
                    TxConnectionListener.this.setTrackByTx(false);
                    TxConnectionListener.this.transactionSynchronization = null;
                    return false;
                }
                if (TxConnectionListener.this.trace) {
                    TxConnectionListener.this.getLog().trace((Object)("Enlisted resource " + TxConnectionListener.this));
                }
                this.enlisted = true;
                return true;
            }
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (TxConnectionListener.this.getState().equals((Object)ConnectionState.DESTROYED)) {
                return;
            }
            if (!this.equals(TxConnectionListener.this.transactionSynchronization)) {
                if (!this.wasTrackByTx) {
                    return;
                }
                String message = "afterCompletion called with wrong tx! Expected: " + this + ", actual: " + TxConnectionListener.this.transactionSynchronization;
                IllegalStateException e = new IllegalStateException(message);
                TxConnectionListener.this.getLog().error((Object)"There is something wrong with the pooling?", (Throwable)e);
            }
            TxConnectionListener.this.transactionSynchronization = null;
            if (this.wasTrackByTx) {
                if (TxConnectionListener.this.trace) {
                    TxConnectionListener.this.getLog().trace((Object)("afterCompletion(" + status + ") isTrackByTx=" + TxConnectionListener.this.isTrackByTx() + " for " + TxConnectionListener.this));
                }
                if (TxConnectionListener.this.wasFreed(null)) {
                    TxConnectionListener.this.getConnectionManager().returnManagedConnection(TxConnectionListener.this, false);
                }
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TxSync").append(System.identityHashCode(this));
            buffer.append("{tx=").append(this.currentTx);
            buffer.append(" wasTrackByTx=").append(this.wasTrackByTx);
            buffer.append(" enlisted=").append(this.enlisted);
            buffer.append("}");
            return buffer.toString();
        }
    }
}

