/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool;

import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.connectionmanager.pool.AbstractPool;
import org.jboss.jca.core.connectionmanager.pool.PreFillPoolSupport;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;

public abstract class AbstractPrefillPool
extends AbstractPool
implements PreFillPoolSupport {
    private boolean shouldPrefill = false;

    protected AbstractPrefillPool(ManagedConnectionFactory mcf, PoolConfiguration pc, boolean noTxSeparatePools) {
        super(mcf, pc, noTxSeparatePools);
        this.shouldPrefill = pc.isPrefill();
    }

    @Override
    public void prefill() {
        this.prefill(null, null, false);
    }

    @Override
    public void prefill(boolean noTxSeperatePool) {
        this.prefill(null, null, noTxSeperatePool);
    }

    @Override
    public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxnSeperatePool) {
        if (this.shouldPrefill()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to prefill pool: " + this.getName()));
            }
            try {
                Object key = this.getKey(subject, cri, noTxnSeperatePool);
                this.getSubPool(key, subject, cri);
            }
            catch (Throwable t) {
                this.log.error((Object)("Unable to prefill pool: " + this.getName()), t);
            }
        }
    }

    @Override
    public boolean shouldPrefill() {
        return this.shouldPrefill;
    }
}

