/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.api;

import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.connectionmanager.pool.strategy.OnePool;
import org.jboss.jca.core.connectionmanager.pool.strategy.PoolByCri;
import org.jboss.jca.core.connectionmanager.pool.strategy.PoolBySubject;
import org.jboss.jca.core.connectionmanager.pool.strategy.PoolBySubjectAndCri;

public class PoolFactory {
    public Pool create(PoolStrategy strategy, ManagedConnectionFactory mcf, PoolConfiguration pc, boolean noTxSeparatePools) {
        if (strategy == null) {
            throw new IllegalArgumentException("Strategy is null");
        }
        if (mcf == null) {
            throw new IllegalArgumentException("MCF is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        switch (strategy) {
            case POOL_BY_CRI: {
                return new PoolByCri(mcf, pc, noTxSeparatePools);
            }
            case POOL_BY_SUBJECT: {
                return new PoolBySubject(mcf, pc, noTxSeparatePools);
            }
            case POOL_BY_SUBJECT_AND_CRI: {
                return new PoolBySubjectAndCri(mcf, pc, noTxSeparatePools);
            }
            case ONE_POOL: {
                return new OnePool(mcf, pc, noTxSeparatePools);
            }
        }
        throw new IllegalArgumentException("Unknown strategy " + (Object)((Object)strategy));
    }
}

