/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.idle;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleConnectionRemovalSupport;
import org.jboss.logging.Logger;

public class IdleRemover {
    private static Logger logger = Logger.getLogger(IdleRemover.class);
    private static final String VALIDATOR_THREAD_NAME = "JBossConnectionValidator";
    private static final IdleRemover INSTANCE = new IdleRemover();
    private CopyOnWriteArrayList<IdleConnectionRemovalSupport> registeredPools = new CopyOnWriteArrayList();
    private ExecutorService executorService = null;
    private long interval = Long.MAX_VALUE;
    private long next = Long.MAX_VALUE;
    private Lock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();

    private IdleRemover() {
        this.executorService = Executors.newSingleThreadExecutor(new ValidatorThreadFactory());
        this.executorService.execute(new JBossConnectionValidator());
    }

    public static void registerPool(IdleConnectionRemovalSupport mcp, long interval) {
        INSTANCE.internalRegisterPool(mcp, interval);
    }

    public static void unregisterPool(IdleConnectionRemovalSupport mcp) {
        INSTANCE.internalUnregisterPool(mcp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRegisterPool(IdleConnectionRemovalSupport mcp, long interval) {
        try {
            this.lock.lock();
            this.registeredPools.addIfAbsent(mcp);
            if (interval > 1L && interval / 2L < this.interval) {
                this.interval = interval / 2L;
                long maybeNext = System.currentTimeMillis() + this.interval;
                if (this.next > maybeNext && maybeNext > 0L) {
                    this.next = maybeNext;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("internalRegisterPool: about to notify thread: old next: " + this.next + ", new next: " + maybeNext));
                    }
                    this.condition.signal();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void internalUnregisterPool(IdleConnectionRemovalSupport mcp) {
        this.registeredPools.remove(mcp);
        if (this.registeredPools.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"internalUnregisterPool: setting interval to Long.MAX_VALUE");
            }
            this.interval = Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBackgroundThread() {
        try {
            IdleRemover.INSTANCE.lock.lock();
        }
        finally {
            IdleRemover.INSTANCE.lock.unlock();
        }
    }

    static /* synthetic */ Lock access$100(IdleRemover x0) {
        return x0.lock;
    }

    static /* synthetic */ IdleRemover access$200() {
        return INSTANCE;
    }

    static /* synthetic */ long access$300(IdleRemover x0) {
        return x0.interval;
    }

    static /* synthetic */ Condition access$400(IdleRemover x0) {
        return x0.condition;
    }

    static /* synthetic */ Logger access$500() {
        return logger;
    }

    static /* synthetic */ CopyOnWriteArrayList access$600(IdleRemover x0) {
        return x0.registeredPools;
    }

    static /* synthetic */ long access$702(IdleRemover x0, long x1) {
        x0.next = x1;
        return x0.next;
    }

    static /* synthetic */ long access$700(IdleRemover x0) {
        return x0.next;
    }

    private class JBossConnectionValidator
    implements Runnable {
        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class ValidatorThreadFactory
    implements ThreadFactory {
        private ValidatorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, IdleRemover.VALIDATOR_THREAD_NAME);
            thread.setDaemon(true);
            return thread;
        }
    }
}

